/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.exception;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * blancoDbƂĂ̗ONX
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2007.02.16
 * @author IGA Tosiki
 */
public class BlancoDbExceptionClassDotNet {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "BlancoDbException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "blancoDbƂĂ̗ONX쐬܂B";

    /**
     * blancoCg IuWFNgt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * ̃NX܂܂\[XR[hB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    public BlancoDbExceptionClassDotNet(final BlancoCgObjectFactory cgFactory,
            final String argPackage) {
        fCgFactory = cgFactory;
        fCgSourceFile = fCgFactory.createSourceFile(argPackage,
                "This code is generated by blanco Framework.");
    }

    public BlancoCgSourceFile expand() {
        final BlancoCgClass cgClass = fCgFactory.createClass(CLASS_NAME, null);
        fCgSourceFile.getClassList().add(cgClass);

        cgClass.getExtendClassList().add(
                fCgFactory.createType("System.Exception"));
        cgClass.setAbstract(true);
        {
            final List<String> listDesc = cgClass.getLangDoc()
                    .getDescriptionList();

            listDesc.add("blancoDb̗ONXB");
            listDesc.add("̃NXblancoDb\[XR[hŗp܂ B");
            listDesc.add("̃NX́A\[XR[h̃t@CƂėp܂B");
            listDesc.add("");
            listDesc.add("@author blanco Framework");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "string", "O̐"));

            cgMethod.setSuperclassInvocation("base(reason)");
        }

        {
            // ƂSqlExceptionێ邽߂̃RXgN^B
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "string", "O̐"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("innerException",
                            "System.Exception", "݂̗ǑłOB"));

            cgMethod.setSuperclassInvocation("base(reason, innerException)");
        }

        return fCgSourceFile;
    }
}