/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker.odp;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractClass;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.query.FinalizeDotNet;
import blanco.db.expander.query.PrepareStatementMethodDotNet;
import blanco.db.expander.query.field.LogFieldDotNet;
import blanco.db.expander.query.field.odp.ConnectionFieldOdpDotNet;
import blanco.db.expander.query.field.odp.StatementFieldOdpDotNet;
import blanco.db.expander.query.field.odp.TransactionFieldOdpDotNet;
import blanco.db.expander.query.invoker.CloseMethodDotNet;
import blanco.db.expander.query.iterator.odp.SetInputParameterMethodOdpDotNet;
import blanco.db.expander.query.odp.GetQueryMethodOdpDotNet;
import blanco.db.expander.query.odp.GetStatementMethodOdpDotNet;
import blanco.db.expander.query.odp.PrepareStatementMethod2OdpDotNet;
import blanco.db.expander.query.odp.QueryConstructor2OdpDotNet;
import blanco.db.expander.query.odp.QueryConstructorOdpDotNet;

/**
 * ʂ̃NXWJ邽߂̃NXB
 */
public class QueryInvokerClassOdpDotNet extends BlancoDbAbstractClass {

    public QueryInvokerClassOdpDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory) {
        super(argDbSetting, argSqlInfo, argCgFactory);
    }

    public BlancoCgSourceFile expand() {
        final String className = BlancoNameAdjuster.toClassName(fSqlInfo
                .getName())
                + "Invoker";

        fCgSourceFile = fCgFactory.createSourceFile(fDbSetting.getBasePackage()
                + ".query", "This code is generated by blanco Framework.");
        fCgClass = fCgFactory.createClass(className, className + "NX");
        fCgSourceFile.getClassList().add(fCgClass);

        // TODO o[WƂ̌݊BL킳p邱ƂƂB
        fCgSourceFile.getImportList().add("System.Data.SqlDbType");

        fCgClass.getLangDoc().getDescriptionList()
                .add("QueryInvokerɑNXłB");
        fCgClass.getLangDoc().getDescriptionList().add(
                "s^SQLbsOĊeANZT񋟂܂B");
        if (fSqlInfo.getSingle()) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    "VO: L (҂鏈1)");
        }

        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".exception.IntegrityConstraintException");

        // BlancoDbUtil͏ɃC|[g܂B
        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".util.BlancoDbUtil");

        new ConnectionFieldOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        new TransactionFieldOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        new StatementFieldOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();

        if (fDbSetting.getLogging()) {
            fCgSourceFile.getImportList().add(
                    "org.apache.commons.logging.LogFactory");
            new LogFieldDotNet(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
        }

        new QueryConstructorOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        new QueryConstructor2OdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        new GetQueryMethodOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();

        new PrepareStatementMethodDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        // t.iga
        new PrepareStatementMethod2OdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();

        // ̓p[^ꍇɂ̂bind܂B
        if (fSqlInfo.getInParameterList().size() > 0) {
            new SetInputParameterMethodOdpDotNet(fDbSetting, fSqlInfo,
                    fCgFactory, fCgSourceFile, fCgClass, false).expand();
        }
        new ExecuteUpdateMethodOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        if (fSqlInfo.getSingle()) {
            new ExecuteSingleUpdateMethodOdpDotNet(fDbSetting, fSqlInfo,
                    fCgFactory, fCgSourceFile, fCgClass).expand();
        }

        new GetStatementMethodOdpDotNet(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();

        new CloseMethodDotNet(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new FinalizeDotNet(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        return fCgSourceFile;
    }
}