/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.odp;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author tosiki iga
 */
public class GetStatementMethodOdpDotNet extends BlancoDbAbstractMethod {
    public GetStatementMethodOdpDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("GetStatement",
                "Xe[gg (SqlCommand) 擾܂B");
        fCgClass.getMethodList().add(cgMethod);

        String resultType = "Oracle.DataAccess.Client.OracleCommand";

        cgMethod.setReturn(fCgFactory.createReturn(resultType,
                "StatementIuWFNg"));

        cgMethod.getLangDoc().getDescriptionList().add(
                "̃\bhĂяoƂ͐܂BʓI Statement𒼐ڗpKv͂܂B");

        final List<String> listLine = cgMethod.getLineList();

        listLine.add("return fStatement;");
    }
}