/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;

/**
 * blancoDbɂ blancoCgɊւ郆[eBeBW߂NXB
 * 
 * ɗǂgݍ킹ɂāȀꏊňꊇď܂B
 * 
 * @author ToshikiIga
 */
public class BlancoDbCgUtilDotNet {
    /**
     * \bh SQLÕX[ǉ܂B
     * 
     * @param cgFactory
     * @param cgMethod
     */
    public static void addExceptionToMethodSqlException(
            final BlancoCgObjectFactory cgFactory, final BlancoCgMethod cgMethod) {
        cgMethod.getThrowList().add(
                cgFactory.createException("System.Data.SqlClient.SqlException",
                        "SQLOꍇB"));
    }

    /**
     * \bh fbhbNƃ^CAEg̃X[ǉ܂B
     * 
     * @param cgFactory
     * @param cgMethod
     * @param storage
     */
    public static void addExceptionToMethodDeadlockTimeoutException(
            final BlancoCgObjectFactory cgFactory,
            final BlancoCgMethod cgMethod, final BlancoDbSetting storage) {
        cgMethod.getThrowList().add(
                cgFactory.createException(BlancoDbUtil
                        .getRuntimePackage(storage)
                        + ".exception.DeadlockException",
                        "f[^x[XfbhbNꍇB"));
        cgMethod.getThrowList().add(
                cgFactory
                        .createException(BlancoDbUtil
                                .getRuntimePackage(storage)
                                + ".exception.TimeoutException",
                                "f[^x[X^CAEgꍇB"));
    }

    /**
     * \bh IntegrityConstraintExceptioñX[ǉ܂B
     * 
     * @param cgFactory
     * @param cgMethod
     * @param storage
     */
    public static void addExceptionToMethodIntegrityConstraintException(
            final BlancoCgObjectFactory cgFactory,
            final BlancoCgMethod cgMethod, final BlancoDbSetting storage) {
        cgMethod.getThrowList().add(
                cgFactory.createException(BlancoDbUtil
                        .getRuntimePackage(storage)
                        + ".exception.IntegrityConstraintException",
                        "f[^x[XᔽꍇB"));
    }

    /**
     * \bhɃ\bhJn̓T^IȃMOǉ܂B
     * 
     * T^Ił͂ȂOɂẮÃ\bh͗pɌʂɎĂB
     * 
     * @param cgMethod
     */
    public static void addBeginLogToMethod(final BlancoCgMethod cgMethod) {
        final List<String> listLine = cgMethod.getLineList();

        listLine.add("if (fLog.isDebugEnabled()) {");
        listLine.add("fLog.debug(\"" + cgMethod.getName() + "\");");
        listLine.add("}");
        listLine.add("");
    }
}
