/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.csv.resourcebundle.BlancoCsvRuntimeUtilDotNetResourceBundle;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;

public class BlancoCsvExpandRuntimeUtilDotNet {
    final BlancoCsvRuntimeUtilDotNetResourceBundle bundle = new BlancoCsvRuntimeUtilDotNetResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public void expand(final BlancoCsvStructureDotNet processStructure,
            final File directoryTarget) {

        final String className = bundle.getClassName();

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getRuntimePackage()
                + bundle.getPackagePrefix(), null);
        fCgSourceFile.setEncoding(fEncoding);

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(className, null);
        fCgSourceFile.getClassList().add(fCgClass);

        fCgSourceFile.getLangDoc().getDescriptionList().add(
                bundle.getFilecomment());
        fCgClass.getLangDoc().getDescriptionList().add(
                bundle.getClasscomment01());
        fCgClass.getLangDoc().getDescriptionList().add(
                bundle.getClasscomment02());
        fCgSourceFile.getImportList().add("System.String");
        fCgSourceFile.getImportList().add("System.IO.StringReader");
        fCgSourceFile.getImportList().add("System.Text.StringBuilder");
        fCgSourceFile.getImportList().add(
                processStructure.getRuntimePackage()
                        + ".io.BlancoCsvIOException");

        /**
         * ReadToken\bhWJ܂B
         */
        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(bundle
                    .getReadtokenName(), bundle.getReadtokenJavadoc());
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);

            // \bh̃VOj`w
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter(bundle.getReadtokenArg01Name(),
                            bundle.getReadtokenArg01Type(), bundle
                                    .getReadtokenArg01Javadoc()));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter(bundle.getReadtokenArg02Name(),
                            bundle.getReadtokenArg02Type(), bundle
                                    .getReadtokenArg02Javadoc()));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter(bundle.getReadtokenArg03Name(),
                            bundle.getReadtokenArg03Type(), bundle
                                    .getReadtokenArg03Javadoc()));

            cgMethod.setReturn(fCgFactory.createReturn(bundle
                    .getReadtokenReturnType(), bundle
                    .getReadtokenReturnJavadoc()));

            // \bh̎
            cgMethod.getLineList().add("if (argReader == null)");
            cgMethod.getLineList().add("{");
            cgMethod
                    .getLineList()
                    .add(
                            "throw new ArgumentException(\"ReadToken\bh̃[_null^܂B\");");
            cgMethod.getLineList().add("}");

            cgMethod.getLineList().add(bundle.getReadtokenLine01());
            cgMethod.getLineList().add(bundle.getReadtokenLine02());
            cgMethod.getLineList().add(bundle.getReadtokenLine03());
            cgMethod.getLineList().add(bundle.getReadtokenLine04());
            cgMethod.getLineList().add(bundle.getReadtokenLine05());
            cgMethod.getLineList().add(bundle.getReadtokenLine06());
            cgMethod.getLineList().add(bundle.getReadtokenLine07());
            cgMethod.getLineList().add(bundle.getReadtokenLine08());
            cgMethod.getLineList().add(bundle.getReadtokenLine09());
            cgMethod.getLineList().add(bundle.getReadtokenLine10());
            cgMethod.getLineList().add(bundle.getReadtokenLine11());
            cgMethod.getLineList().add(bundle.getReadtokenLine12());
            cgMethod.getLineList().add(bundle.getReadtokenLine13());
            cgMethod.getLineList().add(bundle.getReadtokenLine14());
            cgMethod.getLineList().add(bundle.getReadtokenLine15());
            cgMethod.getLineList().add(bundle.getReadtokenLine16());
            cgMethod.getLineList().add(bundle.getReadtokenLine17());
            cgMethod.getLineList().add(bundle.getReadtokenLine18());
            cgMethod.getLineList().add(bundle.getReadtokenLine19());
            cgMethod.getLineList().add(bundle.getReadtokenLine20());
        }

        /**
         * ReadTokenWithQuote\bhWJ܂B
         */
        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(bundle
                    .getReadtokenwithquoteName(), bundle
                    .getReadtokenwithquoteJavadoc());
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);

            // \bh̃VOj`w
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter(bundle
                            .getReadtokenwithquoteArg01Name(), bundle
                            .getReadtokenwithquoteArg01Type(), bundle
                            .getReadtokenwithquoteArg01Javadoc()));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter(bundle
                            .getReadtokenwithquoteArg02Name(), bundle
                            .getReadtokenwithquoteArg02Type(), bundle
                            .getReadtokenwithquoteArg02Javadoc()));
            cgMethod.setReturn(fCgFactory.createReturn(bundle
                    .getReadtokenwithquoteReturnType(), bundle
                    .getReadtokenwithquoteReturnJavadoc()));

            // \bh̎
            cgMethod.getLineList().add("if (argReader == null)");
            cgMethod.getLineList().add("{");
            cgMethod
                    .getLineList()
                    .add(
                            "throw new ArgumentException(\"ReadTokenWithQuote\bh̃[_null^܂B\");");
            cgMethod.getLineList().add("}");

            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine01());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine02());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0301());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0302());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0303());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0401());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0402());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0403());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0404());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0405());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0406());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0407());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0408());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0409());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0410());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine0411());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine05());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine06());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine07());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine08());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine09());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine10());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine11());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine12());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine13());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine14());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine15());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine16());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine17());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine18());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine19());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine20());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine21());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine22());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine23());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine24());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine25());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine26());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine27());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine28());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine29());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine3001());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine3002());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine31());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine32());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine33());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine35());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine36());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine37());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine38());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine39());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine40());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine41());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine42());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine43());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine44());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine45());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine46());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine47());
            cgMethod.getLineList().add(bundle.getReadtokenwithquoteLine48());
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(bundle
                    .getGettokenwithquoteName(), bundle
                    .getGettokenwithquoteJavadoc());
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);

            // \bh̃VOj`w
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("value", bundle
                            .getGettokenwithquoteArg01Type(), bundle
                            .getGettokenwithquoteArg01Javadoc()));
            cgMethod.setReturn(fCgFactory.createReturn(bundle
                    .getGettokenwithquoteReturnType(), bundle
                    .getGettokenwithquoteReturnJavadoc()));

            // \bh̎
            cgMethod.getLineList().add("if (value == null)");
            cgMethod.getLineList().add("{");
            cgMethod
                    .getLineList()
                    .add(
                            "throw new ArgumentException(\"GetTokenWithQuote\bhvaluenull^܂B\");");
            cgMethod.getLineList().add("}");

            fCgSourceFile.getImportList().add(
                    bundle.getGettokenwithquoteAddusingtype01());
            fCgSourceFile.getImportList().add(
                    bundle.getGettokenwithquoteAddusingtype02());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine01());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine02());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine03());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine04());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine05());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine06());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine07());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine08());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine09());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine10());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine11());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine12());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine13());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine14());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine15());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine16());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine17());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine18());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine19());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine20());
            cgMethod.getLineList().add(bundle.getGettokenwithquoteLine21());
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod("GetBytes",
                    "oCgzɕϊ܂B");
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);

            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("inputString", "string",
                            "ϊ̕B"));
            cgMethod.setReturn(fCgFactory.createReturn("byte[]",
                    "oCgzɕϊ̕B"));

            cgMethod.getLineList().add("if (inputString == null)");
            cgMethod.getLineList().add("{");
            cgMethod
                    .getLineList()
                    .add(
                            "throw new ArgumentException(\"GetBytes\bhnull^܂B\");");
            cgMethod.getLineList().add("}");

            cgMethod.getLineList().add("// oCgzɕϊ܂B");
            cgMethod
                    .getLineList()
                    .add(
                            "byte[] inputBytes = Encoding.Unicode.GetBytes(inputString);");
            cgMethod.getLineList().add(
                    "// GR[fBO擾܂Bł̓VtgJISւ̃GR[fBO擾Ă܂B");
            cgMethod.getLineList().add("//TODO: `Ŏw肳ĂGR[hKv܂B");
            cgMethod.getLineList().add(
                    "Encoding targetEncoding = Encoding.GetEncoding(932);");
            cgMethod.getLineList().add("// ۂɃR[hϊB");
            cgMethod
                    .getLineList()
                    .add(
                            "return Encoding.Convert(Encoding.Unicode, targetEncoding, inputBytes);");
        }

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getCsSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
