/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.stringgroup;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.stringgroup.message.BlancoStringGroupMessage;
import blanco.stringgroup.resourcebundle.BlancoStringGroupResourceBundle;
import blanco.stringgroup.valueobject.BlancoStringGroupFieldStructure;
import blanco.stringgroup.valueobject.BlancoStringGroupStructure;

/**
 * uO[v`vExcell當O[vNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringGroupXml2SourceFile {
    /**
     * bZ[W`B
     */
    private final BlancoStringGroupMessage fMsg = new BlancoStringGroupMessage();

    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoStringGroupResourceBundle fBundle = new BlancoStringGroupResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoCgSupportedLang.NOT_DEFINED;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argTargetLang
     *            o͑ΏۂƂȂvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final File argDirectoryTarget)
            throws IOException {

        fTargetLang = new BlancoCgSupportedLang().convertToInt(argTargetLang);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
        case BlancoCgSupportedLang.DELPHI:
            break;
        default:
            throw new IllegalArgumentException(fMsg.getMbsgi002(argTargetLang));
        }

        final BlancoStringGroupStructure[] structures = new BlancoStringGroupXmlParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], argDirectoryTarget);
        }
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void structure2Source(final BlancoStringGroupStructure argStructure,
            final File argDirectoryTarget) {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argStructure.getPackage(),
                null);
        fCgSourceFile.setName(argStructure.getName()
                + BlancoStringUtil.null2Blank(argStructure.getSuffix()));
        fCgSourceFile.setEncoding(fEncoding);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.DELPHI:
            // Delphił́AUnitƂ̖OՓ˂邽߁Aɏ]NXɋIT܂B
            fCgClass = fCgFactory.createClass("T" + argStructure.getName()
                    + BlancoStringUtil.null2Blank(argStructure.getSuffix()),
                    BlancoStringUtil.null2Blank(argStructure.getDescription()));
            break;
        default:
            fCgClass = fCgFactory.createClass(argStructure.getName()
                    + BlancoStringUtil.null2Blank(argStructure.getSuffix()),
                    BlancoStringUtil.null2Blank(argStructure.getDescription()));
            break;
        }
        fCgSourceFile.getClassList().add(fCgClass);

        expandField(argStructure);
        expandMethodMatch(argStructure);
        expandMethodMatchIgnoreCase(argStructure);
        expandMethodConvertToInt(argStructure);

        // TODO  JavaɂΉĂ܂B
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
            expandMethodConvertToString(argStructure);
            break;
        }

        BlancoCgTransformerFactory.getSourceTransformer(fTargetLang).transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * 萔tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandField(
            final BlancoStringGroupStructure argProcessStructure) {

        boolean isProcessed = false;
        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);
            if (BlancoStringUtil.null2Blank(fieldLook.getConstant()).length() == 0) {
                continue;
            }

            String description = "";
            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                description += fBundle.getXml2sourceFileFieldNo(fieldLook
                        .getNo()
                        + " ");
            }
            if (fieldLook.getDescription() != null) {
                description += fBundle.getXml2sourceFileDescription(fieldLook
                        .getDescription());
            }

            final BlancoCgField cgField = fCgFactory.createField(fieldLook
                    .getConstant().toUpperCase(), getTypeInt(), description);
            fCgClass.getFieldList().add(cgField);

            cgField.setAccess("public");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault(Integer.toString(indexField + 1));
            isProcessed = true;
        }

        if (isProcessed) {
            final BlancoCgField cgField = fCgFactory.createField("NOT_DEFINED",
                    getTypeInt(), "`BO[vȊO̕܂͒萔`̂́B");
            fCgClass.getFieldList().add(cgField);

            cgField.setAccess("public");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault("-1");
        }
    }

    /**
     * match\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatch(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("match"), "O[vɊ܂܂镶ł邩ǂ𔻒肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "`FbNsB"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeBoolean(),
                "O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription()));
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.JAVA:
            case BlancoCgSupportedLang.CS:
                lineList
                        .add(BlancoCgLineUtil
                                .getIfBegin(
                                        fTargetLang,
                                        BlancoCgLineUtil
                                                .getStringLiteralEnclosure(fTargetLang)
                                                + BlancoCgSourceUtil
                                                        .escapeStringAsSource(
                                                                fTargetLang,
                                                                fieldLook
                                                                        .getValue())
                                                + BlancoCgLineUtil
                                                        .getStringLiteralEnclosure(fTargetLang)
                                                + "."
                                                + getMethodName("equals")
                                                + "(argCheck)"));
                break;
            case BlancoCgSupportedLang.JS:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " == argCheck"));
                break;
            case BlancoCgSupportedLang.VB:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " = argCheck"));
                break;
            case BlancoCgSupportedLang.PHP:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " === $argCheck"));
                break;
            case BlancoCgSupportedLang.RUBY:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " == argCheck"));
                break;
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " == argCheck"));
                break;
            case BlancoCgSupportedLang.DELPHI:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " = argCheck"));
                break;
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "True")
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.DELPHI:
                lineList.add("result := True"
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                lineList.add("exit"
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            default:
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "true")
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            }
            lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));
        }
        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "False")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        case BlancoCgSupportedLang.DELPHI:
            lineList.add("result := False"
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            lineList.add("exit" + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "false")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        }
    }

    /**
     * matchIgnoreCase\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatchIgnoreCase(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("matchIgnoreCase"),
                "O[vɊ܂܂镶ł邩ǂA啶ʂ肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "`FbNsB"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeBoolean(),
                "O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription()));
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.JAVA:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + "." + getMethodName("equalsIgnoreCase")
                                + "(argCheck)"));
                break;
            case BlancoCgSupportedLang.CS:
                lineList
                        .add(BlancoCgLineUtil
                                .getIfBegin(
                                        fTargetLang,
                                        BlancoCgLineUtil
                                                .getStringLiteralEnclosure(fTargetLang)
                                                + BlancoCgSourceUtil
                                                        .escapeStringAsSource(
                                                                fTargetLang,
                                                                fieldLook
                                                                        .getValue())
                                                + BlancoCgLineUtil
                                                        .getStringLiteralEnclosure(fTargetLang)
                                                + "."
                                                + getMethodName("equals")
                                                + "(argCheck, StringComparison.CurrentCultureIgnoreCase)"));
                fCgSourceFile.getImportList().add("System.StringComparison");
                break;
            case BlancoCgSupportedLang.JS:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + ".toUpperCase() == argCheck.toUpperCase()"));
                break;
            case BlancoCgSupportedLang.VB:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + ".ToUpper() = argCheck.ToUpper()"));
                break;
            case BlancoCgSupportedLang.PHP:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        "strtoupper("
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + ") === strtoupper($argCheck)"));
                break;
            case BlancoCgSupportedLang.RUBY:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + ".upcase() == argCheck.upcase()"));
                break;
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + ".upper() == argCheck.upper()"));
                break;
            case BlancoCgSupportedLang.DELPHI:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        "UpperCase("
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + ") = UpperCase(argCheck)"));
                fCgSourceFile.getImportList().add("SysUtils");
                break;
            }
            switch (fTargetLang) {
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "True")
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.DELPHI:
                lineList.add("result := True"
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                lineList.add("exit"
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            default:
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "true")
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            }
            lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));
        }
        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "False")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        case BlancoCgSupportedLang.DELPHI:
            lineList.add("result := False"
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            lineList.add("exit" + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "false")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        }
    }

    /**
     * convertToInt\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodConvertToInt(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("convertToInt"), "񂩂萔ɕϊ܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add(
                "萔`̏ꍇ ^ꂽ񂪕O[vȌꍇɂ NOT_DEFINED ߂܂B");
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "ϊsB"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeInt(), "萔ɕϊ̒lB"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            if (BlancoStringUtil.null2Blank(fieldLook.getConstant()).length() == 0) {
                // 萔`̂̂̓XLbv܂B
                continue;
            }

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription()));
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.JAVA:
            case BlancoCgSupportedLang.CS:
                lineList
                        .add(BlancoCgLineUtil
                                .getIfBegin(
                                        fTargetLang,
                                        BlancoCgLineUtil
                                                .getStringLiteralEnclosure(fTargetLang)
                                                + BlancoCgSourceUtil
                                                        .escapeStringAsSource(
                                                                fTargetLang,
                                                                fieldLook
                                                                        .getValue())
                                                + BlancoCgLineUtil
                                                        .getStringLiteralEnclosure(fTargetLang)
                                                + "."
                                                + getMethodName("equals")
                                                + "(argCheck)"));
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, fieldLook
                        .getConstant().toUpperCase())
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.JS:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " == argCheck"));
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, fCgClass
                        .getName()
                        + "." + fieldLook.getConstant().toUpperCase())
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.VB:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " = argCheck"));
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, fieldLook
                        .getConstant().toUpperCase())
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.PHP:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " === $argCheck"));
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "self::"
                        + fieldLook.getConstant().toUpperCase())
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.RUBY:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " == argCheck"));
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, fieldLook
                        .getConstant().toUpperCase())
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " == argCheck"));
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "self."
                        + fieldLook.getConstant().toUpperCase())
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            case BlancoCgSupportedLang.DELPHI:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                                + BlancoCgSourceUtil.escapeStringAsSource(
                                        fTargetLang, fieldLook.getValue())
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " = argCheck"));
                lineList.add("result := "
                        + fieldLook.getConstant().toUpperCase()
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                lineList.add("exit"
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            }
            lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));
        }

        lineList.add("");
        lineList.add(BlancoCgLineUtil.getSingleLineCommentPrefix(fTargetLang)
                + "Y萔܂łB");

        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.RUBY:
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "NOT_DEFINED")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        case BlancoCgSupportedLang.JS:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, fCgClass
                    .getName()
                    + ".NOT_DEFINED")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        case BlancoCgSupportedLang.PHP:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang,
                    "self::NOT_DEFINED")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang,
                    "self.NOT_DEFINED")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        case BlancoCgSupportedLang.DELPHI:
            lineList.add("result := NOT_DEFINED"
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            lineList.add("exit" + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        }
    }

    /**
     * convertToString\bhWJ܂B
     * 
     * TODO Javaɂ̂ݑΉĂ܂B̌ɂ͑ΉĂ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodConvertToString(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("convertToString"), "萔當ɕϊ܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add("萔ƑΉÂɕϊ܂B");
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeInt(),
                        "ϊs萔B"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeString(),
                "ɕϊ̒lBNOT_DEFINED̏ꍇɂ͒0̕B"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            if (BlancoStringUtil.null2Blank(fieldLook.getConstant()).length() == 0) {
                continue;
            }

            if (fieldLook.getNo() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription()));
            }

            lineList.add("if (argCheck == "
                    + fieldLook.getConstant().toUpperCase() + ") {");
            lineList.add("return "
                    + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                    + BlancoCgSourceUtil.escapeStringAsSource(fTargetLang,
                            fieldLook.getValue())
                    + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            lineList.add("}");
        }

        lineList.add(BlancoCgLineUtil.getSingleLineCommentPrefix(fTargetLang)
                + "`B");
        lineList.add("if (argCheck == NOT_DEFINED) {");
        lineList.add("return "
                + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                + BlancoCgLineUtil.getTerminator(fTargetLang));
        lineList.add("}");

        lineList.add("");
        lineList.add(BlancoCgLineUtil.getSingleLineCommentPrefix(fTargetLang)
                + "ɂY܂łB");
        lineList.add("throw new IllegalArgumentException("
                + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                + "^ꂽl("
                + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                + " + argCheck + "
                + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                + ")͕O[v[" + argProcessStructure.getName()
                + "]ł͒`ȂlłB"
                + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang) + ")"
                + BlancoCgLineUtil.getTerminator(fTargetLang));
    }

    /**
     * vO~Oꏈnɍ boolean ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeBoolean() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "boolean";
        case BlancoCgSupportedLang.CS:
            return "bool";
        case BlancoCgSupportedLang.JS:
            return "boolean";
        case BlancoCgSupportedLang.VB:
            return "Boolean";
        }
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "java.lang.String";
        case BlancoCgSupportedLang.CS:
            return "string";
        case BlancoCgSupportedLang.JS:
            return "string";
        case BlancoCgSupportedLang.VB:
            return "String";
        case BlancoCgSupportedLang.PHP:
            return "string";
        }
    }

    private final String getTypeInt() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        default:
            return "int";
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.DELPHI:
            return "Integer";
        case BlancoCgSupportedLang.PHP:
            return "integer";
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @param argMethodName
     *            \bhB
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return argMethodName;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        case BlancoCgSupportedLang.JS:
            return argMethodName;
        }
    }
}
