/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CacheChangedPath {
    protected int pathIndex;
    protected char action;
    protected int copiedFromPathIndex;
    protected long copiedFromRevision;

    public CacheChangedPath(int pathIndex, char action, int copiedFromPathIndex, long copiedFromRevision) {
        this.pathIndex = pathIndex;
        this.action = action;
        this.copiedFromPathIndex = copiedFromPathIndex;
        this.copiedFromRevision = copiedFromRevision;
    }

    public CacheChangedPath(byte[] bytes) {
        this.fromBytes(bytes);
    }

    public int getPathIndex() {
        return this.pathIndex;
    }

    public char getAction() {
        return this.action;
    }

    public int getCopiedFromPathIndex() {
        return this.copiedFromPathIndex;
    }

    public long getCopiedFromRevision() {
        return this.copiedFromRevision;
    }

    protected final void fromBytes(byte[] bytes) {
        try {
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));
            this.pathIndex = dataIn.readInt();
            this.action = dataIn.readChar();
            byte copyFlag = dataIn.readByte();
            if (copyFlag == 1) {
                this.copiedFromPathIndex = dataIn.readInt();
                this.copiedFromRevision = dataIn.readLong();
            } else {
                this.copiedFromPathIndex = -1;
                this.copiedFromRevision = 0L;
            }
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream bytes = new DataOutputStream(byteArray);
            bytes.writeInt(this.pathIndex);
            bytes.writeChar(this.action);
            if (this.copiedFromPathIndex != -1) {
                bytes.writeByte(1);
                bytes.writeInt(this.copiedFromPathIndex);
                bytes.writeLong(this.copiedFromRevision);
            } else {
                bytes.writeByte(0);
            }
            return byteArray.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

