/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;

public abstract class BaseFetchOperation
extends AbstractActionOperation {
    protected final IRepositoryResource resource;
    protected final RepositoryCache repositoryCache;
    protected final boolean isSkipFetchErrors;
    protected boolean canRun;
    protected long logOptions;
    protected String[] revProps;
    protected ISVNLogEntryCallbackWithError logEntryCallback;

    public BaseFetchOperation(String operationName, IRepositoryResource resource, RepositoryCache repositoryCache, boolean isSkipFetchErrors) {
        super(operationName, SVNRevisionGraphMessages.class);
        this.resource = resource;
        this.repositoryCache = repositoryCache;
        this.isSkipFetchErrors = isSkipFetchErrors;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        TimeMeasure measure = new TimeMeasure("Fetch revisions " + ((Object)((Object)this)).getClass().getName());
        this.prepareData(monitor);
        if (this.canRun) {
            ISVNConnector proxy = this.resource.getRepositoryLocation().acquireSVNProxy();
            try {
                this.fetch(proxy, monitor);
            }
            finally {
                this.finalizeFetch(proxy, monitor);
            }
        }
        measure.end();
    }

    protected void fetch(ISVNConnector proxy, IProgressMonitor monitor) throws Exception {
        long lastErrorRevision = -1L;
        while (true) {
            try {
                proxy.logEntries(SVNUtility.getEntryReference((IRepositoryResource)this.resource.getRepositoryLocation().getRepositoryRoot()), new SVNRevisionRange[]{new SVNRevisionRange(this.getEndSkippedRevision(), this.getStartSkippedRevision())}, this.revProps, 0L, this.logOptions, (ISVNLogEntryCallback)this.logEntryCallback, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                return;
            }
            catch (Exception e) {
                String msg;
                if (e instanceof SVNConnectorCancelException || e instanceof ActivityCancelledException || e instanceof OperationCanceledException) {
                    return;
                }
                if (!this.isSkipFetchErrors) {
                    throw e;
                }
                if (lastErrorRevision == this.getEndSkippedRevision()) {
                    msg = SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.BaseFetchOperation_SkipMessage, (Object[])new Object[]{this.getEndSkippedRevision()});
                    this.reportStatus(4, null, (Throwable)new UnreportableException(msg, (Throwable)e));
                    ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)msg);
                    if (!this.logEntryCallback.skipRevision()) {
                        return;
                    }
                    lastErrorRevision = -1L;
                    continue;
                }
                msg = SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.BaseFetchOperation_RetryMessage, (Object[])new Object[]{this.getEndSkippedRevision()});
                this.reportStatus(2, msg, e);
                this.logEntryCallback.retryRevision();
                lastErrorRevision = this.getEndSkippedRevision();
                continue;
            }
            break;
        }
    }

    protected void finalizeFetch(ISVNConnector proxy, IProgressMonitor monitor) throws Exception {
        this.resource.getRepositoryLocation().releaseSVNProxy(proxy);
        if (this.logEntryCallback.getError() != null) {
            Throwable t = this.logEntryCallback.getError();
            if (!(t instanceof RuntimeException)) {
                t = new UnreportableException(t);
            }
            this.reportStatus(4, null, t);
        }
        if (this.repositoryCache.isDirty()) {
            this.repositoryCache.save(monitor);
        }
        if (this.repositoryCache.getCacheInfo().isDirty()) {
            this.repositoryCache.getCacheInfo().save();
        }
    }

    protected abstract void prepareData(IProgressMonitor var1) throws Exception;

    protected abstract long getStartSkippedRevision();

    protected abstract long getEndSkippedRevision();

    public static interface ISVNLogEntryCallbackWithError
    extends ISVNLogEntryCallback {
        public Throwable getError();

        public boolean skipRevision();

        public void retryRevision();
    }
}

