/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetResourceAnnotationOperation
extends AbstractRepositoryOperation {
    protected SVNAnnotationData[] annotatedLines;
    protected byte[] content;
    protected boolean includeMerged;
    protected SVNRevisionRange revisions;
    protected boolean isRetryIfMergeInfoNotSupported;

    public GetResourceAnnotationOperation(IRepositoryResource resource, SVNRevisionRange revisions) {
        super("Operation_GetAnnotation", SVNMessages.class, new IRepositoryResource[]{resource});
        this.revisions = revisions;
    }

    public boolean getIncludeMerged() {
        return this.includeMerged;
    }

    public void setIncludeMerged(boolean includeMerged) {
        this.includeMerged = includeMerged;
    }

    public void setRetryIfMergeInfoNotSupported(boolean isRetryIfMergeInfoNotSupported) {
        this.isRetryIfMergeInfoNotSupported = isRetryIfMergeInfoNotSupported;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.operableData()[0];
    }

    public SVNAnnotationData[] getAnnotatedLines() {
        return this.annotatedLines;
    }

    public byte[] getContent() {
        return this.content;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ArrayList lines;
        ByteArrayOutputStream stream;
        block6: {
            stream = new ByteArrayOutputStream();
            lines = new ArrayList();
            IRepositoryResource resource = this.operableData()[0];
            IRepositoryLocation location = resource.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                long options = 0x100000L;
                options |= this.includeMerged ? 524288L : 0L;
                ISVNAnnotationCallback callback = new ISVNAnnotationCallback(){

                    public void annotate(String line, SVNAnnotationData data) {
                        lines.add(data);
                        try {
                            stream.write((String.valueOf(line) + "\n").getBytes());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                try {
                    proxy.annotate(SVNUtility.getEntryReference(resource), this.revisions.from, this.revisions.to, options, callback, new SVNProgressMonitor(this, monitor, null));
                }
                catch (SVNConnectorException ex) {
                    if (this.isRetryIfMergeInfoNotSupported && ex.getErrorId() == 200007 && (options & 0x80000L) != 0L) {
                        proxy.annotate(SVNUtility.getEntryReference(resource), this.revisions.from, this.revisions.to, options &= 0xFFFFFFFFFFF7FFFFL, callback, new SVNProgressMonitor(this, monitor, null));
                        break block6;
                    }
                    throw ex;
                }
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
        }
        this.annotatedLines = lines.toArray(new SVNAnnotationData[lines.size()]);
        this.content = stream.toByteArray();
    }

    protected String getShortErrorMessage(Throwable t) {
        if (t instanceof SVNConnectorException && ((SVNConnectorException)t).getErrorId() == 195004) {
            return this.getOperationResource("Error_IsBinary");
        }
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getName()});
    }
}

