/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.extension.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.extension.factory.IPredefinedPropertySet;
import org.eclipse.team.svn.ui.extension.factory.PredefinedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedPropertySet
implements IPredefinedPropertySet {
    @Override
    public List<PredefinedProperty> getPredefinedProperties() {
        ArrayList<PredefinedProperty> properties = new ArrayList<PredefinedProperty>();
        properties.add(new PredefinedProperty(SVNUIMessages.AbstractPropertyEditPanel_svn_description, "", ""));
        properties.add(new PredefinedProperty("svn:eol-style", this.getDescription("SVN_EOL"), ""));
        properties.add(new PredefinedProperty("svn:executable", this.getDescription("SVN_Executable"), ""));
        properties.add(new PredefinedProperty("svn:externals", this.getDescription("SVN_Externals"), ""));
        properties.add(new PredefinedProperty("svn:ignore", this.getDescription("SVN_Ignore"), ""));
        properties.add(new PredefinedProperty("svn:keywords", this.getDescription("SVN_Keywords"), ""));
        properties.add(new PredefinedProperty("svn:mime-type", this.getDescription("SVN_Mimetype"), ""));
        properties.add(new PredefinedProperty("svn:mergeinfo", this.getDescription("SVN_Mergeinfo"), ""));
        properties.add(new PredefinedProperty("svn:needs-lock", this.getDescription("SVN_NeedsLock"), ""));
        this.getBugtrackProperties(properties);
        properties.add(new PredefinedProperty(SVNUIMessages.PropertyEditPanel_tsvn_description, "", ""));
        properties.add(new PredefinedProperty("tsvn:logtemplate", this.getDescription("TSVN_LogTemplate"), ""));
        properties.add(new PredefinedProperty("tsvn:logwidthmarker", this.getDescription("TSVN_LogWidthMarker"), ""));
        properties.add(new PredefinedProperty("tsvn:logminsize", this.getDescription("TSVN_LogMinSize"), ""));
        properties.add(new PredefinedProperty("tsvn:lockmsgminsize", this.getDescription("TSVN_LockMsgMinSize"), ""));
        properties.add(new PredefinedProperty("tsvn:logfilelistenglish", this.getDescription("TSVN_LogFileListEnglish"), ""));
        properties.add(new PredefinedProperty("tsvn:projectlanguage", this.getDescription("TSVN_ProjectLanguage"), ""));
        return properties;
    }

    @Override
    public Map<String, String> getPredefinedPropertiesRegexps() {
        HashMap<String, String> regexpmap = new HashMap<String, String>();
        regexpmap.put("svn:eol-style", "((native)|(LF)|(CR)|(CRLF))");
        regexpmap.put("svn:executable", null);
        regexpmap.put("svn:externals", "");
        regexpmap.put("svn:ignore", "([^\\\\/\\:])+");
        regexpmap.put("svn:keywords", "((Date)|(Revision)|(Author)|(HeadURL)|(Id)|(LastChangedDate)|(Rev)|(LastChangedRevision)|(LastChangedBy)|(URL)|(\\s))+");
        regexpmap.put("svn:mime-type", null);
        regexpmap.put("svn:mergeinfo", null);
        regexpmap.put("svn:needs-lock", null);
        this.getBugtrackRegExps(regexpmap);
        regexpmap.put("tsvn:logtemplate", null);
        regexpmap.put("tsvn:logwidthmarker", "(\\d+)");
        regexpmap.put("tsvn:logminsize", "(\\d+)");
        regexpmap.put("tsvn:lockmsgminsize", "(\\d+)");
        regexpmap.put("tsvn:logfilelistenglish", "((true)|(false))");
        regexpmap.put("tsvn:projectlanguage", null);
        return regexpmap;
    }

    protected void getBugtrackProperties(List<PredefinedProperty> properties) {
        properties.add(new PredefinedProperty(SVNUIMessages.PropertyEditPanel_bugtraq_description, "", ""));
        properties.add(new PredefinedProperty("bugtraq:url", this.getDescription("Bugtraq_URL"), "%BUGID%"));
        properties.add(new PredefinedProperty("bugtraq:logregex", this.getDescription("Bugtraq_LogRegex"), ""));
        properties.add(new PredefinedProperty("bugtraq:label", this.getDescription("Bugtraq_Label"), ""));
        properties.add(new PredefinedProperty("bugtraq:message", this.getDescription("Bugtraq_Message"), "%BUGID%"));
        properties.add(new PredefinedProperty("bugtraq:number", this.getDescription("Bugtraq_Number"), ""));
        properties.add(new PredefinedProperty("bugtraq:warnifnoissue", this.getDescription("Bugtraq_WarnIfNoIssue"), ""));
        properties.add(new PredefinedProperty("bugtraq:append", this.getDescription("Bugtraq_Append"), ""));
    }

    protected void getBugtrackRegExps(HashMap<String, String> regexpmap) {
        regexpmap.put("bugtraq:url", "((http:\\/\\/)|(https:\\/\\/))(\\S+)?((\\%BUGID\\%))(\\S+)?");
        regexpmap.put("bugtraq:logregex", "");
        regexpmap.put("bugtraq:label", null);
        regexpmap.put("bugtraq:message", "");
        regexpmap.put("bugtraq:number", "((true)|(false))");
        regexpmap.put("bugtraq:warnifnoissue", "((true)|(false))");
        regexpmap.put("bugtraq:append", "((true)|(false))");
    }

    protected String getDescription(String id) {
        return SVNUIMessages.getString("Property_" + id);
    }
}

