/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class SVNLocalFileRevision
extends LocalFileRevision
implements IEditableContent {
    public SVNLocalFileRevision(IFile file) {
        super(file);
    }

    public SVNLocalFileRevision(IFileState fileState) {
        super(fileState);
    }

    public String getComment() {
        if (this.getFile() != null) {
            return SVNUIMessages.SVNLocalFileRevision_CurrentVersion;
        }
        return "";
    }

    public String getContentIdentifier() {
        if (this.getFile() != null) {
            return "";
        }
        return "[" + DateFormatter.formatDate(this.getTimestamp()) + "]";
    }

    public boolean isEditable() {
        return this.isCurrentState();
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return dest;
    }

    public void setContent(byte[] newContent) {
        if (this.isEditable()) {
            try {
                this.getFile().setContents((InputStream)new ByteArrayInputStream(newContent), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                UILoggedOperation.reportError(SVNMessages.Operation_GetFileContent_SetContent, ex);
            }
        }
    }
}

