/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.remote;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.BranchTagSelectionComposite;
import org.eclipse.team.svn.ui.composite.DiffFormatComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;

public class CompareBranchTagPanel
extends AbstractDialogPanel {
    protected IRepositoryResource baseResource;
    protected int type;
    protected IRepositoryResource[] branchTagResources;
    protected long currentRevision;
    protected String historyKey;
    protected BranchTagSelectionComposite selectionComposite;
    protected DiffFormatComposite diffFormatComposite;
    protected Label resultText;
    protected IRepositoryResource resourceToCompareWith;

    public CompareBranchTagPanel(IRepositoryResource baseResource, int type, IRepositoryResource[] branchTagResources) {
        this.baseResource = baseResource;
        this.type = type;
        this.branchTagResources = branchTagResources;
        if (type == 0) {
            this.dialogTitle = SVNUIMessages.Compare_Branch_Title;
            this.dialogDescription = SVNUIMessages.Compare_Branch_Description;
            this.defaultMessage = SVNUIMessages.Compare_Branch_Message;
            this.historyKey = "branchCompare";
        } else {
            this.dialogTitle = SVNUIMessages.Compare_Tag_Title;
            this.dialogDescription = SVNUIMessages.Compare_Tag_Description;
            this.defaultMessage = SVNUIMessages.Compare_Tag_Message;
            this.historyKey = "tagCompare";
        }
    }

    protected void createControlsImpl(Composite parent) {
        GridData data = null;
        this.selectionComposite = new BranchTagSelectionComposite(parent, 0, this.baseResource, this.historyKey, this, this.type, this.branchTagResources);
        data = new GridData(768);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setCurrentRevision(this.currentRevision);
        this.diffFormatComposite = new DiffFormatComposite(parent, this);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        Label label = new Label(parent, 0);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.CompareBranchTagPanel_ResultDescription);
        Composite resultComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        resultComposite.setLayout((Layout)layout);
        data = new GridData(768);
        resultComposite.setLayoutData((Object)data);
        resultComposite.setBackground(UIMonitorUtility.getDisplay().getSystemColor(1));
        this.resultText = new Label(resultComposite, 68);
        this.resultText.setLayoutData((Object)new GridData(768));
        this.resultText.setBackground(UIMonitorUtility.getDisplay().getSystemColor(1));
        this.selectionComposite.addUrlModifyListener(new Listener(){

            public void handleEvent(Event event) {
                CompareBranchTagPanel.this.setResultLabel();
            }
        });
        this.selectionComposite.addUrlVerifier(new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                if (BranchTagSelectionComposite.getResourceToCompareWith(CompareBranchTagPanel.this.baseResource, CompareBranchTagPanel.this.getSelectedResource()) == null) {
                    return SVNUIMessages.CompareBranchTagPanel_ConstructResultVerifierError;
                }
                return null;
            }

            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        this.setResultLabel();
    }

    protected void setResultLabel() {
        String text = SVNUIMessages.CompareBranchTagPanel_ResultNone;
        this.resourceToCompareWith = null;
        if (this.getSelectedResource() != null) {
            this.resourceToCompareWith = BranchTagSelectionComposite.getResourceToCompareWith(this.baseResource, this.getSelectedResource());
            if (this.resourceToCompareWith != null) {
                text = this.resourceToCompareWith.getUrl();
            }
        }
        this.resultText.setText(text);
    }

    public String getDiffFile() {
        return this.diffFormatComposite.getDiffFile();
    }

    public IRepositoryResource getResourceToCompareWith() {
        return this.resourceToCompareWith;
    }

    private IRepositoryResource getSelectedResource() {
        return this.selectionComposite.getSelectedResource();
    }

    protected void saveChangesImpl() {
        this.selectionComposite.saveChanges();
    }

    protected void cancelChangesImpl() {
    }
}

