/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.ApplyPropertyMethodComposite;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.extension.factory.PredefinedProperty;
import org.eclipse.team.svn.ui.properties.AbstractPropertyEditPanel;
import org.eclipse.team.svn.ui.verifier.PropertyVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePropertyEditPanel
extends AbstractPropertyEditPanel {
    public static int SINGLE_FILE = 0;
    public static int MULTIPLE_FILES = 1;
    public static int MIXED_RESOURCES = 2;
    protected Button recursiveButton;
    protected ApplyPropertyMethodComposite applyComposite;
    protected int resourcesType;
    protected boolean recursiveSelected;
    protected boolean applyToAll;
    protected boolean applyToFiles;
    protected boolean applyToFolders;
    protected IResource[] selectedResources;
    protected boolean strict;

    public ResourcePropertyEditPanel(SVNProperty[] data, IResource[] selectedResources, boolean strict) {
        super(data, data != null ? SVNUIMessages.PropertyEditPanel_Title_Edit : SVNUIMessages.PropertyEditPanel_Title_Add, SVNUIMessages.PropertyEditPanel_Description);
        this.strict = strict;
        this.selectedResources = selectedResources;
        this.resourcesType = this.computeResourcesType();
        this.fillVerifiersMap();
    }

    @Override
    protected void fillVerifiersMap() {
        String[] properties = this.predefinedPropertiesRegexps.keySet().toArray(new String[0]);
        IRepositoryResource base = SVNRemoteStorage.instance().asRepositoryResource(this.selectedResources[0]);
        int i = 0;
        while (i < properties.length) {
            this.verifiers.put(properties[i], new PropertyVerifier("EditPropertiesInputField", (String)this.predefinedPropertiesRegexps.get(properties[i]), properties[i], base));
            ++i;
        }
        i = 0;
        while (i < this.customProps.length) {
            this.verifiers.put(this.customProps[i].propName, new PropertyVerifier("EditPropertiesInputField", this.customProps[i].regExp.equals("") ? null : this.customProps[i].regExp, this.customProps[i].propName, base));
            ++i;
        }
    }

    @Override
    protected List<PredefinedProperty> getPredefinedProperties() {
        return ExtensionsManager.getInstance().getPredefinedPropertySet().getPredefinedProperties();
    }

    @Override
    protected Map<String, String> getPredefinedPropertiesRegexps() {
        return ExtensionsManager.getInstance().getPredefinedPropertySet().getPredefinedPropertiesRegexps();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isRecursiveSelected() {
        return this.recursiveSelected;
    }

    public int getApplyMethod() {
        return this.applyComposite == null ? 0 : this.applyComposite.getApplyMethod();
    }

    public String getFilterMask() {
        return this.applyComposite == null ? "" : this.applyComposite.getFilterMask();
    }

    public boolean useMask() {
        return this.applyComposite == null ? false : this.applyComposite.useMask();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        super.createControlsImpl(parent);
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
                this.recursiveButton = new Button(parent, 32);
                this.recursiveButton.setText(SVNUIMessages.PropertyEditPanel_Recursively);
                this.recursiveButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ResourcePropertyEditPanel.this.refreshControlsEnablement();
                        ResourcePropertyEditPanel.this.validateContent();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            this.applyComposite = new ApplyPropertyMethodComposite(parent, 0, this, this.resourcesType);
            this.applyComposite.setLayoutData(new GridData(768));
        }
        if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
            this.refreshControlsEnablement();
        }
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.setPropsDialogContext";
    }

    protected int computeResourcesType() {
        boolean singleResource = this.selectedResources.length == 1;
        boolean allFiles = true;
        int i = 0;
        while (i < this.selectedResources.length) {
            if (!(this.selectedResources[i] instanceof IFile)) {
                allFiles = false;
                break;
            }
            ++i;
        }
        if (allFiles) {
            return singleResource ? SINGLE_FILE : MULTIPLE_FILES;
        }
        return MIXED_RESOURCES;
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
                this.recursiveSelected = this.recursiveButton.getSelection();
            }
            if (this.applyComposite.isEnabled()) {
                this.applyComposite.saveChanges();
            }
        }
    }

    protected void refreshControlsEnablement() {
        this.applyComposite.setEnabled(this.recursiveButton.getSelection());
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(590, -1);
    }
}

