/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.net.URL;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class URLVerifier
extends AbstractFormattedVerifier {
    protected static final String ERROR_REASON = "$ERROR_REASON$";
    protected static String ERROR_MESSAGE_SHORT;
    protected static String ERROR_MESSAGE_FULL;

    public URLVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_SHORT = SVNUIMessages.format((String)SVNUIMessages.Verifier_URL_Short, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_FULL = SVNUIMessages.format((String)SVNUIMessages.Verifier_URL_Full, (Object[])new String[]{"$FIELD_NAME$", ERROR_REASON});
    }

    protected String getErrorMessageImpl(Control input) {
        String url = this.getText(input);
        try {
            URL svnUrl = SVNUtility.getSVNUrl((String)url);
            String host = svnUrl.getHost();
            if (!host.matches("[a-zA-Z0-9_\\-]+(?:\\.[a-zA-Z0-9_\\-]+)*") && host.length() > 0 || host.length() == 0 && !"file".equals(svnUrl.getProtocol())) {
                this.setPlaceHolder(ERROR_REASON, SVNUIMessages.Verifier_URL_NoHost);
                return ERROR_MESSAGE_FULL;
            }
            return null;
        }
        catch (Exception ex) {
            this.setPlaceHolder(ERROR_REASON, ex.getMessage());
            return ex.getMessage() == null ? ERROR_MESSAGE_SHORT : ERROR_MESSAGE_FULL;
        }
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

