/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.delphi;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgEnum;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;

/**
 * BlancoCgClass\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgClassDelphiSourceExpander {

    /**
     * ClassWJ܂B
     * 
     * @param cgClass
     *            ΏۂƂȂNXB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformClass(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        // ŏɃNXLangDocɓWJB
        if (cgClass.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgClass.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgClass.getLangDoc().getTitle() == null) {
            cgClass.getLangDoc().setTitle(cgClass.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocDelphiSourceExpander().transformLangDoc(cgClass
                .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgClass, argSourceLines);

        final StringBuffer buf = new StringBuffer();

        // Delphiłclasŝɉݒ肵܂
        // if (BlancoStringUtil.null2Blank(cgClass.getAccess()).length() > 0) {
        // buf.append(cgClass.getAccess() + " ");
        // }
        // if (cgClass.getAbstract()) {
        // buf.append("abstract ");
        // }
        // if (cgClass.getFinal()) {
        // buf.append("final ");
        // }

        buf.append(cgClass.getName());

        // eNXWJB
        expandExtendClassList(cgClass, argSourceFile, buf);

        // eC^tF[XWJB
        expandImplementInterfaceList(cgClass, argSourceFile, buf);

        // sm肵ďo{B
        argSourceLines.add(buf.toString());

        // NX̃ubN̊JnB
        argSourceLines.add("");

        // ŗ񋓑̂WJB
        // expandEnumList(cgClass, argSourceFile, argSourceLines);

        // ŃtB[hWJB
        expandFieldList(cgClass, argSourceFile, argSourceLines);

        // Ń\bh錾WJB
        expandMethodDeclarationList(cgClass, argSourceFile, argSourceLines);

        // NX̃ubN̏IB
        argSourceLines.add("end;");

        // implementation
        argSourceLines.add("implementation");

        // Ń\bhWJB
        expandMethodList(cgClass, argSourceFile, argSourceLines);

        // end.
        argSourceLines.add("end.");

    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgClass
     *            NXB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgClass cgClass,
            final List<java.lang.String> argSourceLines) {
        for (int index = 0; index < cgClass.getAnnotationList().size(); index++) {
            final String strAnnotation = cgClass.getAnnotationList().get(index);
            // C#.NETAnnotation []ŋLq܂B
            argSourceLines.add("[" + strAnnotation + "]");
        }
    }

    /**
     * eNXWJ܂B
     * 
     * BlancoCgInterfaceWJ̍ۂɁÃ\bhʏƂČĂяoĂ͂Ȃ܂B
     * ̋ʉ́AėWƔfĂ܂B
     * 
     * @param cgClass
     *            NX̃o[IuWFNgB
     * @param argBuf
     *            o͐敶obt@B
     */
    private void expandExtendClassList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final StringBuffer argBuf) {
        if (cgClass.getExtendClassList().size() == 0) {
            argBuf.append(" = class(TObject)");
            return;
        }
        for (int index = 0; index < cgClass.getExtendClassList().size(); index++) {
            final BlancoCgType type = cgClass.getExtendClassList().get(index);

            // importɌ^ǉB
            // argSourceFile.getImportList().add(type.getName());

            if (index == 0) {
                argBuf.append(" = class("
                        + BlancoCgTypeDelphiSourceExpander.toTypeString(type)
                        + ")");
            } else {
                // TODO C#.NEŤpx肾ǂmF{邱ƁB
                // throw new
                // IllegalArgumentException("C#.NETł͌p͈񂵂{ł܂B");

                // TODO _ł͑dpOKłƑz肵܂B
                argBuf.append(", "
                        + BlancoCgTypeDelphiSourceExpander.toTypeString(type));
            }
        }
    }

    /**
     * eC^tF[XWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argBuf
     *            o͐敶obt@B
     */
    private void expandImplementInterfaceList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final StringBuffer argBuf) {
        for (int index = 0; index < cgClass.getImplementInterfaceList().size(); index++) {
            final BlancoCgType type = cgClass.getImplementInterfaceList().get(
                    index);

            // importɌ^ǉB
            // argSourceFile.getImportList().add(type.getName());

            if (index == 0 && cgClass.getExtendClassList().size() == 0) {
                // ŏ̃C^tF[XŁApꍇ : o͂܂B
                argBuf.append(" : ");
            } else {
                argBuf.append(", ");
            }
            argBuf.append(BlancoCgTypeDelphiSourceExpander.toTypeString(type));
        }
    }

    /**
     * NXɊ܂܂eX̗񋓑̂WJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandEnumList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (cgClass.getEnumList() == null) {
            return;
        }

        for (BlancoCgEnum cgEnum : cgClass.getEnumList()) {
            new BlancoCgEnumDelphiSourceExpander().transformEnum(cgEnum,
                    argSourceFile, argSourceLines);
        }
    }

    /**
     * NXɊ܂܂eX̃tB[hWJ܂B
     * 
     * TODO 萔錾D悵ēWJǍϐ錾WJȂǂ̍HvKvłB<br>
     * ݂ o^Ń\[XR[hWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandFieldList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (cgClass.getFieldList() == null) {
            // tB[h̃Xgnull^܂B
            // Ȃ炸tB[h̃XgɂListZbgĂB
            throw new IllegalArgumentException("tB[h̃Xgnull^܂B");
        }

        List<BlancoCgField> publishedList = new ArrayList<BlancoCgField>();
        List<BlancoCgField> publicList = new ArrayList<BlancoCgField>();
        List<BlancoCgField> privateList = new ArrayList<BlancoCgField>();

        for (int index = 0; index < cgClass.getFieldList().size(); index++) {
            final BlancoCgField cgField = cgClass.getFieldList().get(index);

            String access = cgField.getAccess();

            if (isPublished(access)) {
                publishedList.add(cgField);
            } else if (isPublic(access)) {
                publicList.add(cgField);
            } else if (isPrivate(access)) {
                privateList.add(cgField);
            } else {
                // T|[gȂ
            }
        }

        // published tB[h̓WJ
        if (publishedList.size() > 0) {
            argSourceLines.add("published");
        }
        for (int index = 0; index < publishedList.size(); index++) {
            final BlancoCgField cgField = publishedList.get(index);
            // NX̃tB[hƂēWJs܂B
            new BlancoCgFieldDelphiSourceExpander().transformField(cgField,
                    argSourceFile, argSourceLines, false);
        }

        // public tB[h̓WJ
        if (publicList.size() > 0) {
            argSourceLines.add("public");
        }
        for (int index = 0; index < publicList.size(); index++) {
            final BlancoCgField cgField = publicList.get(index);
            // NX̃tB[hƂēWJs܂B
            new BlancoCgFieldDelphiSourceExpander().transformField(cgField,
                    argSourceFile, argSourceLines, false);
        }

        // private tB[h̓WJ
        if (privateList.size() > 0) {
            argSourceLines.add("private");
        }
        for (int index = 0; index < privateList.size(); index++) {
            final BlancoCgField cgField = privateList.get(index);
            // NX̃tB[hƂēWJs܂B
            new BlancoCgFieldDelphiSourceExpander().transformField(cgField,
                    argSourceFile, argSourceLines, false);
        }
    }

    /**
     * NXɊ܂܂eX̃\bh錾WJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandMethodDeclarationList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (cgClass.getMethodList() == null) {
            throw new IllegalArgumentException("\bh̃Xgnull^܂B");
        }

        List<BlancoCgMethod> publishedList = new ArrayList<BlancoCgMethod>();
        List<BlancoCgMethod> publicList = new ArrayList<BlancoCgMethod>();
        List<BlancoCgMethod> privateList = new ArrayList<BlancoCgMethod>();

        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final BlancoCgMethod cgMethod = cgClass.getMethodList().get(index);
            String access = cgMethod.getAccess();

            if (isPublished(access)) {
                publishedList.add(cgMethod);
            } else if (isPublic(access)) {
                publicList.add(cgMethod);
            } else if (isPrivate(access)) {
                privateList.add(cgMethod);
            } else {
                // T|[gȂ
            }
        }

        // published \bh̓WJ
        if (publishedList.size() > 0) {
            // st^B
            argSourceLines.add("");
            argSourceLines.add("published");
        }
        for (int index = 0; index < publishedList.size(); index++) {
            final BlancoCgMethod cgMethod = publishedList.get(index);
            // NX̃tB[hƂēWJs܂B
            new BlancoCgMethodDelphiSourceExpander()
                    .transformMethodDeclaration(cgMethod, argSourceFile,
                            argSourceLines, false);
        }

        // public \bh̓WJ
        if (publicList.size() > 0) {
            // st^B
            argSourceLines.add("");
            argSourceLines.add("public");
        }
        for (int index = 0; index < publicList.size(); index++) {
            final BlancoCgMethod cgMethod = publicList.get(index);
            // NX̃tB[hƂēWJs܂B
            new BlancoCgMethodDelphiSourceExpander()
                    .transformMethodDeclaration(cgMethod, argSourceFile,
                            argSourceLines, false);
        }

        // private \bh̓WJ
        if (privateList.size() > 0) {
            // st^B
            argSourceLines.add("");
            argSourceLines.add("private");
        }
        for (int index = 0; index < privateList.size(); index++) {
            final BlancoCgMethod cgMethod = privateList.get(index);
            // NX̃tB[hƂēWJs܂B
            new BlancoCgMethodDelphiSourceExpander()
                    .transformMethodDeclaration(cgMethod, argSourceFile,
                            argSourceLines, false);
        }

    }

    /**
     * NXɊ܂܂eX̃\bhWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandMethodList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (cgClass.getMethodList() == null) {
            throw new IllegalArgumentException("\bh̃Xgnull^܂B");
        }
        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final BlancoCgMethod cgMethod = cgClass.getMethodList().get(index);
            // NX̃\bhƂēWJs܂B
            new BlancoCgMethodDelphiSourceExpander().transformMethod(cgClass
                    .getName(), cgMethod, argSourceFile, argSourceLines, false);
        }
    }

    private boolean isPrivate(String access) {
        return "private".equals(access);
    }

    private boolean isPublic(String access) {
        return "public".equals(access);
    }

    private boolean isPublished(String access) {
        return "".equals(access) || "published".equals(access);
    }
}
