/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess.stringgroup;

/**
 * T|[g錾̈ꗗێ܂B
 */
public class BlancoBatchProcessSupportedLangStringGroup {
    /**
     * No.1 :JavaB
     */
    public static final int JAVA = 1;

    /**
     * `BO[vȊO̕܂͒萔`̂́B
     */
    public static final int NOT_DEFINED = -1;

    /**
     * O[vɊ܂܂镶ł邩ǂ𔻒肵܂B
     *
     * @param argCheck `FbNsB
     * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
     */
    public boolean match(final String argCheck) {
        // No.1
        // :JavaB
        if ("java".equals(argCheck)) {
            return true;
        }
        return false;
    }

    /**
     * O[vɊ܂܂镶ł邩ǂA啶ʂ肵܂B
     *
     * @param argCheck `FbNsB
     * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
     */
    public boolean matchIgnoreCase(final String argCheck) {
        // No.1
        // :JavaB
        if ("java".equalsIgnoreCase(argCheck)) {
            return true;
        }
        return false;
    }

    /**
     * 񂩂萔ɕϊ܂B
     *
     * 萔`̏ꍇ ^ꂽ񂪕O[vȌꍇɂ NOT_DEFINED ߂܂B
     *
     * @param argCheck ϊsB
     * @return 萔ɕϊ̒lB
     */
    public int convertToInt(final String argCheck) {
        // No.1
        // :JavaB
        if ("java".equals(argCheck)) {
            return JAVA;
        }

        // Y萔܂łB
        return NOT_DEFINED;
    }

    /**
     * 萔當ɕϊ܂B
     *
     * 萔ƑΉÂɕϊ܂B
     *
     * @param argCheck ϊs萔B
     * @return ɕϊ̒lBNOT_DEFINED̏ꍇɂ͒0̕B
     */
    public String convertToString(final int argCheck) {
        // No.1
        // :JavaB
        if (argCheck == JAVA) {
            return "java";
        }
        // `B
        if (argCheck == NOT_DEFINED) {
            return "";
        }

        // ɂY܂łB
        throw new IllegalArgumentException("^ꂽl(" + argCheck + ")͕O[v[BlancoBatchProcessSupportedLang]ł͒`ȂlłB");
    }
}
