/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.field;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractField;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * QueryNXfLogtB[hłB
 * 
 * @author IGA Tosiki
 */
public class LogSqlInParamField extends BlancoDbAbstractField {
    /**
     * QueryNXfLogtB[h̃RXgN^łB
     * 
     * @param bindClassName
     *            OIuWFNgƂČт̃NXB
     * @author IGA Tosiki
     */
    public LogSqlInParamField(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgField cgField = fCgFactory.createField("fLogSqlInParam",
                "java.lang.String",
                "̃NXIɗp郍MÔ߂SQL͕B");
        fCgClass.getFieldList().add(cgField);

        cgField.getLangDoc().getDescriptionList().add(
                "SQL̓p[^~܂B");

        /*
         * WFl[VMbvfUCp^[p\ɂȂړIŁAXR[vprotectedƂ܂B
         */
        cgField.setAccess("protected");
        cgField.setDefault("\"\"");
    }
}
