/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.db.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.db.task.valueobject.BlancoDbProcessInput;

/**
 * Apache Ant^XN [BlancoDb]̃NXB
 *
 * R/O}bsOs BlancoDb Enterprise Edition AntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.db.task]BlancoDbBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancodb&quot; classname=&quot;blanco.db.task.BlancoDbTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoDbTask extends Task {
    /**
     * R/O}bsOs BlancoDb Enterprise Edition AntTaskłB
     */
    protected BlancoDbProcessInput fInput = new BlancoDbProcessInput();

    /**
     * tB[h [jdbcdriver] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcdriverProcessed = false;

    /**
     * tB[h [jdbcurl] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcurlProcessed = false;

    /**
     * tB[h [jdbcuser] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcuserProcessed = false;

    /**
     * tB[h [jdbcpassword] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcpasswordProcessed = false;

    /**
     * tB[h [jdbcdriverfile] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcdriverfileProcessed = false;

    /**
     * tB[h [metadir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldMetadirProcessed = false;

    /**
     * tB[h [tmpdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * tB[h [basepackage] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldBasepackageProcessed = false;

    /**
     * tB[h [runtimepackage] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldRuntimepackageProcessed = false;

    /**
     * tB[h [schema] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldSchemaProcessed = false;

    /**
     * tB[h [table] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTableProcessed = false;

    /**
     * tB[h [sql] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldSqlProcessed = false;

    /**
     * tB[h [failonerror] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldFailonerrorProcessed = false;

    /**
     * tB[h [log] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldLogProcessed = false;

    /**
     * tB[h [logmode] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldLogmodeProcessed = false;

    /**
     * tB[h [logsql] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldLogsqlProcessed = false;

    /**
     * tB[h [statementtimeout] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldStatementtimeoutProcessed = false;

    /**
     * tB[h [executesql] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldExecutesqlProcessed = false;

    /**
     * tB[h [encoding] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldEncodingProcessed = false;

    /**
     * tB[h [convertStringToMsWindows31jUnicode] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldConvertStringToMsWindows31jUnicodeProcessed = false;

    /**
     * tB[h [cache] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldCacheProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[jdbcdriver]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * JDBChCõNXw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcdriver(final String arg) {
        fInput.setJdbcdriver(arg);
        fIsFieldJdbcdriverProcessed = true;
    }

    /**
     * Ant^XN[jdbcdriver]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * JDBChCõNXw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcdriver() {
        return fInput.getJdbcdriver();
    }

    /**
     * Ant^XN[jdbcurl]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * JDBCڑURLw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcurl(final String arg) {
        fInput.setJdbcurl(arg);
        fIsFieldJdbcurlProcessed = true;
    }

    /**
     * Ant^XN[jdbcurl]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * JDBCڑURLw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcurl() {
        return fInput.getJdbcurl();
    }

    /**
     * Ant^XN[jdbcuser]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * JDBCf[^x[Xڑsۂ̃[Uw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcuser(final String arg) {
        fInput.setJdbcuser(arg);
        fIsFieldJdbcuserProcessed = true;
    }

    /**
     * Ant^XN[jdbcuser]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * JDBCf[^x[Xڑsۂ̃[Uw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcuser() {
        return fInput.getJdbcuser();
    }

    /**
     * Ant^XN[jdbcpassword]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * JDBCf[^x[Xڑsۂ̃pX[hw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcpassword(final String arg) {
        fInput.setJdbcpassword(arg);
        fIsFieldJdbcpasswordProcessed = true;
    }

    /**
     * Ant^XN[jdbcpassword]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * JDBCf[^x[Xڑsۂ̃pX[hw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcpassword() {
        return fInput.getJdbcpassword();
    }

    /**
     * Ant^XN[jdbcdriverfile]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * JDBChCo jar t@Cw肵܂Bʏ͗p܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcdriverfile(final String arg) {
        fInput.setJdbcdriverfile(arg);
        fIsFieldJdbcdriverfileProcessed = true;
    }

    /**
     * Ant^XN[jdbcdriverfile]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * JDBChCo jar t@Cw肵܂Bʏ͗p܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcdriverfile() {
        return fInput.getJdbcdriverfile();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 6<br>
     * SQL`^t@Ci[ĂfBNgw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
        fIsFieldMetadirProcessed = true;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 6<br>
     * SQL`^t@Ci[ĂfBNgw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 7<br>
     * e|tH_w肵܂Bw̏ꍇɂ̓JgtmptH_𗘗p܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 7<br>
     * e|tH_w肵܂Bw̏ꍇɂ̓JgtmptH_𗘗p܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 8<br>
     * blancoDbJava\[XR[ho͂fBNgw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 8<br>
     * blancoDbJava\[XR[ho͂fBNgw肵܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[basepackage]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 9<br>
     * blancoDbJava\[XR[h𐶐ۂ̊ƂȂpbP[Ww肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setBasepackage(final String arg) {
        fInput.setBasepackage(arg);
        fIsFieldBasepackageProcessed = true;
    }

    /**
     * Ant^XN[basepackage]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 9<br>
     * blancoDbJava\[XR[h𐶐ۂ̊ƂȂpbP[Ww肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getBasepackage() {
        return fInput.getBasepackage();
    }

    /**
     * Ant^XN[runtimepackage]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 10<br>
     * ^CNX𐶐鐶w肵܂Bw̏ꍇɂ basepackageɐ܂B<br>
     *
     * @param arg Zbgl
     */
    public void setRuntimepackage(final String arg) {
        fInput.setRuntimepackage(arg);
        fIsFieldRuntimepackageProcessed = true;
    }

    /**
     * Ant^XN[runtimepackage]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 10<br>
     * ^CNX𐶐鐶w肵܂Bw̏ꍇɂ basepackageɐ܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getRuntimepackage() {
        return fInput.getRuntimepackage();
    }

    /**
     * Ant^XN[schema]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 11<br>
     * P\擾ۂ̃XL[}B{IɖwłBOraclȅꍇɂ̂݁A[U啶̂w肵܂BOraclȅꍇ w肵ȂƁAVXe\܂ŌĂ܂s邽߂łB<br>
     *
     * @param arg Zbgl
     */
    public void setSchema(final String arg) {
        fInput.setSchema(arg);
        fIsFieldSchemaProcessed = true;
    }

    /**
     * Ant^XN[schema]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 11<br>
     * P\擾ۂ̃XL[}B{IɖwłBOraclȅꍇɂ̂݁A[U啶̂w肵܂BOraclȅꍇ w肵ȂƁAVXe\܂ŌĂ܂s邽߂łB<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSchema() {
        return fInput.getSchema();
    }

    /**
     * Ant^XN[table]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 12<br>
     * trueݒ肷ƒP\̂߂̃ANZTER[h𐶐܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTable(final String arg) {
        fInput.setTable(arg);
        fIsFieldTableProcessed = true;
    }

    /**
     * Ant^XN[table]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 12<br>
     * trueݒ肷ƒP\̂߂̃ANZTER[h𐶐܂B<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTable() {
        return fInput.getTable();
    }

    /**
     * Ant^XN[sql]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 13<br>
     * trueݒ肷SQL`R[h𐶐܂B<br>
     *
     * @param arg Zbgl
     */
    public void setSql(final String arg) {
        fInput.setSql(arg);
        fIsFieldSqlProcessed = true;
    }

    /**
     * Ant^XN[sql]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 13<br>
     * trueݒ肷SQL`R[h𐶐܂B<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSql() {
        return fInput.getSql();
    }

    /**
     * Ant^XN[failonerror]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 14<br>
     * SQL `\[XR[hɎsۂɏ𒆒f܂B<br>
     *
     * @param arg Zbgl
     */
    public void setFailonerror(final String arg) {
        fInput.setFailonerror(arg);
        fIsFieldFailonerrorProcessed = true;
    }

    /**
     * Ant^XN[failonerror]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 14<br>
     * SQL `\[XR[hɎsۂɏ𒆒f܂B<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getFailonerror() {
        return fInput.getFailonerror();
    }

    /**
     * Ant^XN[log]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 15<br>
     * trueݒ肷 Jakarta Commonsp̃MOR[h𐶐܂B<br>
     *
     * @param arg Zbgl
     */
    public void setLog(final String arg) {
        fInput.setLog(arg);
        fIsFieldLogProcessed = true;
    }

    /**
     * Ant^XN[log]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 15<br>
     * trueݒ肷 Jakarta Commonsp̃MOR[h𐶐܂B<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getLog() {
        return fInput.getLog();
    }

    /**
     * Ant^XN[logmode]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 16<br>
     * O[h̎wBdebug, performance, sqlid ̂ꂩ̒lwB<br>
     *
     * @param arg Zbgl
     */
    public void setLogmode(final String arg) {
        fInput.setLogmode(arg);
        fIsFieldLogmodeProcessed = true;
    }

    /**
     * Ant^XN[logmode]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 16<br>
     * O[h̎wBdebug, performance, sqlid ̂ꂩ̒lwB<br>
     * ftHgl[debug]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getLogmode() {
        return fInput.getLogmode();
    }

    /**
     * Ant^XN[logsql]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 17<br>
     * SQL Oŏo͂邩ǂ̃tOBulogvulogmodev̓g[Xx̃OfAulogsqlv́Aǐ̂郍OoB<br>
     *
     * @param arg Zbgl
     */
    public void setLogsql(final String arg) {
        fInput.setLogsql(arg);
        fIsFieldLogsqlProcessed = true;
    }

    /**
     * Ant^XN[logsql]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 17<br>
     * SQL Oŏo͂邩ǂ̃tOBulogvulogmodev̓g[Xx̃OfAulogsqlv́Aǐ̂郍OoB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getLogsql() {
        return fInput.getLogsql();
    }

    /**
     * Ant^XN[statementtimeout]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 19<br>
     * Xe[gg̃^CAEglBSQL̃^CAEglݒ肵܂BsetQueryTimeoutɔf܂Bw̏ꍇɂAPIftHgB<br>
     *
     * @param arg Zbgl
     */
    public void setStatementtimeout(final String arg) {
        fInput.setStatementtimeout(arg);
        fIsFieldStatementtimeoutProcessed = true;
    }

    /**
     * Ant^XN[statementtimeout]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 19<br>
     * Xe[gg̃^CAEglBSQL̃^CAEglݒ肵܂BsetQueryTimeoutɔf܂Bw̏ꍇɂAPIftHgB<br>
     *
     * @return ̃tB[h̒l
     */
    public String getStatementtimeout() {
        return fInput.getStatementtimeout();
    }

    /**
     * Ant^XN[executesql]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 20<br>
     * \[XR[hSQL`SQLs邩ǂݒ肷tOBftHg iteratorBiterator:^̂SQLsČ؂Bnone:SQL͎sȂB<br>
     *
     * @param arg Zbgl
     */
    public void setExecutesql(final String arg) {
        fInput.setExecutesql(arg);
        fIsFieldExecutesqlProcessed = true;
    }

    /**
     * Ant^XN[executesql]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 20<br>
     * \[XR[hSQL`SQLs邩ǂݒ肷tOBftHg iteratorBiterator:^̂SQLsČ؂Bnone:SQL͎sȂB<br>
     * ftHgl[iterator]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getExecutesql() {
        return fInput.getExecutesql();
    }

    /**
     * Ant^XN[encoding]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 21<br>
     * \[Xt@C̕GR[fBOw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setEncoding(final String arg) {
        fInput.setEncoding(arg);
        fIsFieldEncodingProcessed = true;
    }

    /**
     * Ant^XN[encoding]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 21<br>
     * \[Xt@C̕GR[fBOw肵܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getEncoding() {
        return fInput.getEncoding();
    }

    /**
     * Ant^XN[convertStringToMsWindows31jUnicode]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 22<br>
     * ɂāAMicrosoft Windows 3.1{ł̃jR[hւƕϊ邩ǂBʂɔf܂B<br>
     *
     * @param arg Zbgl
     */
    public void setConvertStringToMsWindows31jUnicode(final String arg) {
        fInput.setConvertStringToMsWindows31jUnicode(arg);
        fIsFieldConvertStringToMsWindows31jUnicodeProcessed = true;
    }

    /**
     * Ant^XN[convertStringToMsWindows31jUnicode]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 22<br>
     * ɂāAMicrosoft Windows 3.1{ł̃jR[hւƕϊ邩ǂBʂɔf܂B<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getConvertStringToMsWindows31jUnicode() {
        return fInput.getConvertStringToMsWindows31jUnicode();
    }

    /**
     * Ant^XN[cache]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 23<br>
     * `^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB<br>
     *
     * @param arg Zbgl
     */
    public void setCache(final String arg) {
        fInput.setCache(arg);
        fIsFieldCacheProcessed = true;
    }

    /**
     * Ant^XN[cache]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 23<br>
     * `^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getCache() {
        return fInput.getCache();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoDbTask begin.");

        // ڔԍ[1]AAgr[g[jdbcdriver]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcdriverProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcdriver]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[jdbcurl]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcurlProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcurl]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[3]AAgr[g[jdbcuser]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcuserProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcuser]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[4]AAgr[g[jdbcpassword]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcpasswordProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcpassword]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[6]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldMetadirProcessed == false) {
            throw new BuildException("K{Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[9]AAgr[g[basepackage]͕K{͂łB̓`FbNs܂B
        if (fIsFieldBasepackageProcessed == false) {
            throw new BuildException("K{Agr[g[basepackage]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- jdbcdriver:[" + getJdbcdriver() + "]");
            System.out.println("- jdbcurl:[" + getJdbcurl() + "]");
            System.out.println("- jdbcuser:[" + getJdbcuser() + "]");
            System.out.println("- jdbcpassword:[" + getJdbcpassword() + "]");
            System.out.println("- jdbcdriverfile:[" + getJdbcdriverfile() + "]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- basepackage:[" + getBasepackage() + "]");
            System.out.println("- runtimepackage:[" + getRuntimepackage() + "]");
            System.out.println("- schema:[" + getSchema() + "]");
            System.out.println("- table:[" + getTable() + "]");
            System.out.println("- sql:[" + getSql() + "]");
            System.out.println("- failonerror:[" + getFailonerror() + "]");
            System.out.println("- log:[" + getLog() + "]");
            System.out.println("- logmode:[" + getLogmode() + "]");
            System.out.println("- logsql:[" + getLogsql() + "]");
            System.out.println("- statementtimeout:[" + getStatementtimeout() + "]");
            System.out.println("- executesql:[" + getExecutesql() + "]");
            System.out.println("- encoding:[" + getEncoding() + "]");
            System.out.println("- convertStringToMsWindows31jUnicode:[" + getConvertStringToMsWindows31jUnicode() + "]");
            System.out.println("- cache:[" + getCache() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoDbProcessC^tF[X blanco.db.taskpbP[W BlancoDbProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoDbProcess proc = new BlancoDbProcessImpl();
            if (proc.execute(fInput) != BlancoDbBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
