<?php
/**
 * SoftBank.php
 *
 * PHP versions 4 and 5
 *
 * @package   Blocken
 * @author    Kouhei Suzuki <sigma@mfer.jp>
 * @copyright 2006-2009 SIGMA Project
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version   $Id: SoftBank.php 27 2009-04-25 06:39:17Z sigmax $
 */
if ( basename( $_SERVER[ 'SCRIPT_NAME' ] ) == basename( __FILE__ ) ) { exit; }

require_once 'Net/UserAgent/Mobile/SoftBank.php';

class BlockenMobile_SoftBank extends Net_UserAgent_Mobile_SoftBank
{
    /**
     * @access private
     * @var    array $_aryDisplayMap
     */
    var $_aryDisplayMap = null;

    /**
     * isFlash()
     *
     * @access public
     * @param  float  $fVersion
     * @return mixed            float | boolean
     */
    function isFlash( $fVersion = 0 )
    {
        $aryDisplay = $this->_getDisplay();

        $fFlash = floatval( $aryDisplay[ 'flash' ] );
        if ( 0 != $fFlash && $fVersion <= $fFlash )
        {
            return $fFlash;
        }

        return false;
    }

    /**
     * isPdf()
     *
     * @access public
     * @return boolean
     */
    function isPdf()
    {
        return false;
    }

    /**
     * isSimulator()
     *
     * @access public
     * @return boolean
     */
    function isSimulator()
    {
        if ( $this->getHeader( 'X-EMULATOR-DISPLAY' ) )
        {
            return true;
        }

        return false;
    }

    /**
     * hasEmoji()
     *
     * @access public
     * @param  string  $sMsg
     * @return boolean
     */
    function hasEmoji( $sMsg )
    {
        $sMsg = mb_convert_encoding( $sMsg, 'UTF-8', 'SJIS' );
        $bRet = preg_match( '/〓/', $sMsg );
        if ( 0 == $bRet )
        {
            $bRet = preg_match( '/\x1b...\x0f/', $sMsg );
        }

        return ( 1 == $bRet ) ? true : false;
    }

    /**
     * &convertEmoji()
     *
     * @access public
     * @return array
     */
    function &convertEmoji()
    {
        $aryEmoji = array(
            '/&#63647;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6a, 0x0f ),
            '/&#63648;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x69, 0x0f ),
            '/&#63649;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6b, 0x0f ),
            '/&#63650;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x68, 0x0f ),
            '/&#63651;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x5d, 0x0f ),
            '/&#63652;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x63, 0x0f ),
            '/&#63653;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x69, 0x0f ),
            '/&#63654;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x5c, 0x0f ),
            '/&#63655;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x5f, 0x0f ),
            '/&#63656;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x60, 0x0f ),
            '/&#63657;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x61, 0x0f ),
            '/&#63658;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x62, 0x0f ),
            '/&#63659;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x63, 0x0f ),
            '/&#63660;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x64, 0x0f ),
            '/&#63661;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x65, 0x0f ),
            '/&#63662;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x66, 0x0f ),
            '/&#63663;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x67, 0x0f ),
            '/&#63664;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x68, 0x0f ),
            '/&#63665;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x69, 0x0f ),
            '/&#63666;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x6a, 0x0f ),
            '/&#63667;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x35, 0x0f ),
            '/&#63668;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x36, 0x0f ),
            '/&#63669;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x34, 0x0f ),
            '/&#63670;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x35, 0x0f ),
            '/&#63671;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x38, 0x0f ),
            '/&#63672;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x33, 0x0f ),
            '/&#63673;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x4a, 0x0f ),
            '/&#63674;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x52, 0x0f ),
            '/&#63675;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x2b, 0x0f ),
            '/&#63676;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x3e, 0x0f ),
            '/&#63677;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x54, 0x0f ),
            '/&#63678;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x55, 0x0f ),
            '/&#63679;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x3b, 0x0f ),
            '/&#63680;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x4e, 0x0f ),
            '/&#63681;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x79, 0x0f ),
            '/&#63682;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x22, 0x0f ),
            '/&#63683;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x3d, 0x0f ),
            '/&#63684;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x56, 0x0f ),
            '/&#63685;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x58, 0x0f ),
            '/&#63686;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x73, 0x0f ),
            '/&#63687;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x75, 0x0f ),
            '/&#63688;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x6d, 0x0f ),
            '/&#63689;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x74, 0x0f ),
            '/&#63690;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x78, 0x0f ),
            '/&#63691;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x76, 0x0f ),
            '/&#63692;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x5a, 0x0f ),
            '/&#63693;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x6f, 0x0f ),
            '/&#63694;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x6e, 0x0f ),
            '/&#63695;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x71, 0x0f ),
            '/&#63696;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x63, 0x0f ),
            '/&#63697;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x65, 0x0f ),
            '/&#63698;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x64, 0x0f ),
            '/&#63699;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x67, 0x0f ),
            '/&#63700;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x40, 0x0f ),
            '/&#63701;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x5e, 0x0f ),
            '/&#63702;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x33, 0x0f ),
            '/&#63703;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x5c, 0x0f ),
            '/&#63704;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x5d, 0x0f ),
            '/&#63705;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x56, 0x0f ),
            '/&#63706;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x44, 0x0f ),
            '/&#63707;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x2a, 0x0f ),
            '/&#63708;/'  => pack( 'C*', 0x1b, 0x24, 0x51, 0x22, 0x0f ),
            '/&#63709;/'  => pack( 'C*', 0x1b, 0x24, 0x51, 0x23, 0x0f ),
            '/&#63710;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x4f, 0x0f ),
            '/&#63711;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x45, 0x0f ),
            '/&#63712;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x2e, 0x0f ),
            '/&#63713;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x28, 0x0f ),
            '/&#63714;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x28, 0x0f ),
            '/&#63715;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x43, 0x0f ),
            '/&#63716;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x68, 0x0f ),
            '/&#63717;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x34, 0x0f ),
            '/&#63718;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x32, 0x0f ),
            '/&#63719;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x6b, 0x0f ),
            '/&#63720;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x29, 0x0f ),
            '/&#63721;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x2a, 0x0f ),
            '/&#63722;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x21, 0x0f ),
            '/&#63723;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x4a, 0x0f ),
            '/&#63724;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x4b, 0x0f ),
            '/&#63725;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x46, 0x0f ),
            '/&#63726;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x2c, 0x0f ),
            '/&#63727;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x2e, 0x0f ),
            '/&#63728;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x2d, 0x0f ),
            '/&#63729;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x2f, 0x0f ),
            '/&#63730;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x39, 0x0f ),
            '/&#63731;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x3b, 0x0f ),
            '/&#63732;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x30, 0x0f ),
            '/&#63733;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x31, 0x0f ),
            '/&#63734;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x32, 0x0f ),
            '/&#63735;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x58, 0x0f ),
            '/&#63736;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x57, 0x0f ),
            '/&#63737;/'  => pack( 'C*', 0x1b, 0x24, 0x51, 0x56, 0x0f ),
            '/&#63738;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x27, 0x0f ),
            '/&#63739;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x31, 0x0f ),
            '/&#63740;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x2a, 0x0f ),
            '/&#63808;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6c, 0x0f ),
            '/&#63809;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6c, 0x0f ),
            '/&#63810;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6c, 0x0f ),
            '/&#63811;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6c, 0x0f ),
            '/&#63812;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6c, 0x0f ),
            '/&#63813;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x72, 0x0f ),
            '/&#63814;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x6f, 0x0f ),
            '/&#63815;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x3c, 0x0f ),
            '/&#63816;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x53, 0x0f ),
            '/&#63817;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x59, 0x0f ),
            '/&#63858;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x24, 0x0f ),
            '/&#63859;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x23, 0x0f ),
            '/&#63860;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x2b, 0x0f ),
            '/&#63861;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x7a, 0x0f ),
            '/&#63862;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x7a, 0x0f ),
            '/&#63863;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x23, 0x0f ),
            '/&#63864;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x7a, 0x0f ),
            '/&#63865;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x7a, 0x0f ),
            '/&#63866;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x35, 0x0f ),
            '/&#63867;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x36, 0x0f ),
            '/&#63868;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x49, 0x0f ),
            '/&#63869;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x5f, 0x0f ),
            '/&#63870;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x55, 0x0f ),
            '/&#63872;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x29, 0x0f ),
            '/&#63873;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x34, 0x0f ),
            '/&#63874;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x32, 0x0f ),
            '/&#63875;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x23, 0x0f ),
            '/&#63876;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x31, 0x0f ),
            '/&#63877;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x30, 0x0f ),
            '/&#63878;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x73, 0x0f ),
            '/&#63879;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x3c, 0x0f ),
            '/&#63880;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x3d, 0x0f ),
            '/&#63881;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x3e, 0x0f ),
            '/&#63882;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x3f, 0x0f ),
            '/&#63883;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x40, 0x0f ),
            '/&#63884;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x41, 0x0f ),
            '/&#63885;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x42, 0x0f ),
            '/&#63886;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x43, 0x0f ),
            '/&#63887;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x44, 0x0f ),
            '/&#63888;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x45, 0x0f ),
            '/&#63920;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x6d, 0x0f ),
            '/&#63889;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x42, 0x0f ),
            '/&#63890;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x47, 0x0f ),
            '/&#63891;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x43, 0x0f ),
            '/&#63892;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x47, 0x0f ),
            '/&#63893;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x77, 0x0f ),
            '/&#63894;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x79, 0x0f ),
            '/&#63895;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x78, 0x0f ),
            '/&#63896;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x27, 0x0f ),
            '/&#63897;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x26, 0x0f ),
            '/&#63898;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x56, 0x0f ),
            '/&#63899;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x5e, 0x0f ),
            '/&#63900;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x43, 0x0f ),
            '/&#63901;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x24, 0x0f ),
            '/&#63902;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x23, 0x0f ),
            '/&#63903;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x4e, 0x0f ),
            '/&#63904;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x2f, 0x0f ),
            '/&#63905;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x54, 0x0f ),
            '/&#63906;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x2d, 0x0f ),
            '/&#63907;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x31, 0x0f ),
            '/&#63908;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x46, 0x0f ),
            '/&#63909;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x58, 0x0f ),
            '/&#63910;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x5c, 0x0f ),
            '/&#63911;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x41, 0x0f ),
            '/&#63912;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x56, 0x0f ),
            '/&#63913;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x57, 0x0f ),
            '/&#63914;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x26, 0x0f ),
            '/&#63915;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x51, 0x0f ),
            '/&#63916;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x51, 0x0f ),
            '/&#63917;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x50, 0x0f ),
            '/&#63918;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x4c, 0x0f ),
            '/&#63919;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x4c, 0x0f ),
            '/&#63824;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x44, 0x0f ),
            '/&#63825;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x4f, 0x0f ),
            '/&#63826;/'  => pack( 'C*', 0x1b, 0x24, 0x4f, 0x21, 0x0f ),
            '/&#63829;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x2c, 0x0f ),
            '/&#63830;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x3f, 0x0f ),
            '/&#63831;/'  => pack( 'C*', 0x1b, 0x24, 0x50, 0x6b, 0x0f ),
            '/&#63835;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x5a, 0x0f ),
            '/&#63836;/'  => pack( 'C*', 0x1b, 0x24, 0x46, 0x5c, 0x0f ),
            '/&#63837;/'  => pack( 'C*', 0x1b, 0x24, 0x45, 0x3c, 0x0f ),
            '/&#63838;/'  => pack( 'C*', 0x1b, 0x24, 0x47, 0x4d, 0x0f ),
            '/&#xE70C;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x7a, 0x0f ),
            '/&#xE70D;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x7a, 0x0f ),
            '/&#xE70E;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x26, 0x0f ),
            '/&#xE70F;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x69, 0x0f ),
            '/&#xE710;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x3c, 0x0f ),
            '/&#xE711;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x3b, 0x0f ),
            '/&#xE712;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x33, 0x0f ),
            '/&#xE713;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x45, 0x0f ),
            '/&#xE714;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x4f, 0x0f ),
            '/&#xE715;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x4f, 0x0f ),
            '/&#xE716;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x2c, 0x0f ),
            '/&#xE717;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x23, 0x0f ),
            '/&#xE718;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x36, 0x0f ),
            '/&#xE719;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x21, 0x0f ),
            '/&#xE71A;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x2e, 0x0f ),
            '/&#xE71B;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x54, 0x0f ),
            '/&#xE71C;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x47, 0x0f ),
            '/&#xE71D;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x56, 0x0f ),
            '/&#xE71E;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x58, 0x0f ),
            '/&#xE71F;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x4b, 0x0f ),
            '/&#xE720;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x23, 0x0f ),
            '/&#xE721;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x2a, 0x0f ),
            '/&#xE722;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x35, 0x0f ),
            '/&#xE723;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x28, 0x0f ),
            '/&#xE724;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x36, 0x0f ),
            '/&#xE725;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x2e, 0x0f ),
            '/&#xE726;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x26, 0x0f ),
            '/&#xE727;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x2e, 0x0f ),
            '/&#xE728;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x25, 0x0f ),
            '/&#xE729;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x25, 0x0f ),
            '/&#xE72A;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x2a, 0x0f ),
            '/&#xE72B;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x26, 0x0f ),
            '/&#xE72C;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x22, 0x0f ),
            '/&#xE72D;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x31, 0x0f ),
            '/&#xE72E;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x33, 0x0f ),
            '/&#xE72F;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x53, 0x0f ),
            '/&#xE730;/i' => pack( 'C*', 0x1b, 0x24, 0x51, 0x45, 0x0f ),
            '/&#xE731;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x6e, 0x0f ),
            '/&#xE732;/i' => pack( 'C*', 0x1b, 0x24, 0x51, 0x57, 0x0f ),
            '/&#xE733;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x35, 0x0f ),
            '/&#xE734;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x35, 0x0f ),
            '/&#xE735;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x67, 0x0f ),
            '/&#xE736;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x6f, 0x0f ),
            '/&#xE737;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x72, 0x0f ),
            '/&#xE738;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x53, 0x0f ),
            '/&#xE739;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x4b, 0x0f ),
            '/&#xE73A;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x2d, 0x0f ),
            '/&#xE73B;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x4a, 0x0f ),
            '/&#xE73C;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x50, 0x0f ),
            '/&#xE73D;/i' => pack( 'C*', 0x1b, 0x24, 0x46, 0x4e, 0x0f ),
            '/&#xE73E;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x77, 0x0f ),
            '/&#xE73F;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x5e, 0x0f ),
            '/&#xE740;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x5b, 0x0f ),
            '/&#xE741;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x30, 0x0f ),
            '/&#xE742;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x69, 0x0f ),
            '/&#xE743;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x24, 0x0f ),
            '/&#xE744;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x68, 0x0f ),
            '/&#xE745;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x65, 0x0f ),
            '/&#xE746;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x30, 0x0f ),
            '/&#xE747;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x38, 0x0f ),
            '/&#xE748;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x50, 0x0f ),
            '/&#xE749;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x62, 0x0f ),
            '/&#xE74A;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x66, 0x0f ),
            '/&#xE74B;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x2b, 0x0f ),
            '/&#xE74C;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x60, 0x0f ),
            '/&#xE74D;/i' => pack( 'C*', 0x1b, 0x24, 0x4f, 0x59, 0x0f ),
            '/&#xE74E;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x61, 0x0f ),
            '/&#xE74F;/i' => pack( 'C*', 0x1b, 0x24, 0x51, 0x43, 0x0f ),
            '/&#xE750;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x75, 0x0f ),
            '/&#xE751;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x39, 0x0f ),
            '/&#xE752;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x76, 0x0f ),
            '/&#xE753;/i' => pack( 'C*', 0x1b, 0x24, 0x50, 0x24, 0x0f ),
            '/&#xE754;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x3a, 0x0f ),
            '/&#xE755;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x2b, 0x0f ),
            '/&#xE756;/i' => pack( 'C*', 0x1b, 0x24, 0x47, 0x64, 0x0f ),
            '/&#xE757;/i' => pack( 'C*', 0x1b, 0x24, 0x45, 0x27, 0x0f )
        );

        return $aryEmoji;
    }

    /**
     * _getDisplay()
     *
     * @access private
     * @return array
     */
    function _getDisplay()
    {
        if ( ! isset( $this->_aryDisplayMap ) )
        {
            $sXml = file_get_contents( BLOCKEN_MOBI_S_MAP );

            $aryValues  = array();
            $aryIndexes = array();

            $resParser = xml_parser_create();
            xml_parse_into_struct( $resParser, $sXml, $aryValues, $aryIndexes );
            xml_parser_free( $resParser );

            foreach ( $aryIndexes[ 'TERMINAL' ] as $iModelIndexes )
            {
                $sModelName = $aryValues[ $iModelIndexes ][ 'attributes' ][ 'MODEL' ];
                $this->_aryDisplayMap[ $sModelName ] = array();
                foreach ( $aryValues[ $iModelIndexes ][ 'attributes' ] as $sAttributeName => $sAttributeValue )
                {
                    $this->_aryDisplayMap[ $sModelName ][ strtolower( $sAttributeName ) ] = $sAttributeValue;
                }
            }
        }

        $aryDisplay = array();

        if ( array_key_exists( $this->getModel(), $this->_aryDisplayMap ) )
        {
            $aryDisplay = $this->_aryDisplayMap[ $this->getModel() ];
        }

        return $aryDisplay;
    }
}
?>
