package base;
import java.util.HashMap;


//容量をケチるためのもの
// 格納するオブジェクトは equals とhashCodeを実装していること
public class ByteMap{
	HashMap OtoB =new HashMap();
	Object[] ary=new Object[256];
	int[]    lru=new int   [256];
	int used;
	long create_time;

	public ByteMap(){
		// マップを作成した時刻
		create_time = System.currentTimeMillis();
		// 0番はnullのためにキープ
		ary[0]=null;
		used=1;
	}

	// 現在の時刻を示す値
	private int getLRU()
	{ return (int) ((System.currentTimeMillis()-create_time)>>12); }
	// 範囲は(2**31) 精度は (2**12)/1000 秒 (4.096秒刻み)
	// 278年くらい持つ

	// バイトからオブジェクトへ
	public final Object get(int key){
	//参照時には時刻を記録しないほうがいいんじゃないか？	lru[key]=getLRU();
		return ary[key];
	}
	// オブジェクトからバイトへ
	public final int put(Object o){
		if(o==null) return 0;
		int key;
		// 既に記録されているかも
		Integer b = (Integer)OtoB.get(o);
		if(b!=null){ lru[key=b.intValue()]=getLRU(); return key;}

		// 追加もしくは更新
		if( used<256 ){
			key= used++;
		}else{
			// 0 はnull固定なので初期は1,比較は2から
			int tval  =lru[key=1];
			for(int i=2;i<256;++i) if(lru[i]<tval) tval=lru[key=i];
			OtoB.remove(ary[key]);
		}
		lru[key]=getLRU();
		OtoB.put( (ary[key]=o) , new Integer(key) );
		return key;
	}
}
