package base;
import java.nio.channels.*;
import java.util.*;

// Selectorを回す
public class SelectorRun implements Runnable{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("base.selectorrun");
	static{ logger.setLevel(null); }

	public static long select_interval_min = 100;
	public static int select_interval_step = 256; // 256で2倍
	public static long select_interval_max = 1000;

	static long next = System.currentTimeMillis();

	synchronized void my_wait(long time){
		try{wait(time);}catch(Throwable e){}
	}

	boolean dmode = false;
	int cost_count =0;
	long wantwrite_step = System.currentTimeMillis();
	long sps_before   = System.currentTimeMillis();
	long sps_progress = 0;
	long sps_count    = 0;

	Selector selector;
//	Server server;
	public volatile boolean exit_flag =false;
	public volatile boolean closed    =false;

	Object[][] saved_keys = null;
	int avail;
	long now;
	long step;
	long timer_next = System.currentTimeMillis();

	// アイテムを処理する部分はAWTイベントディスパッチスレッドから実行する
	public void run(){
	//	dmode=true;
		// キーを順に見る
		Set keys = selector.keys();
		Set selected = selector.selectedKeys();
		String status = "avail="+avail+" selectedKeys="+selected.size()+" keys="+keys.size();
		for(Iterator it= selected.iterator();it.hasNext();){
			SelectionKey key = (SelectionKey)it.next();it.remove();
			SelectorItem item = (SelectorItem)key.attachment();
			SelectableChannel channel=key.channel();
			try{
				int ready_flag = key.readyOps();
				if(dmode) logger.finest(
					 ((ready_flag&key.OP_CONNECT )!=0?"C":"")
					+((ready_flag&key.OP_ACCEPT  )!=0?"A":"")
					+((ready_flag&key.OP_READ    )!=0?"R":"")
					+((ready_flag&key.OP_WRITE   )!=0?"W":"")
					+" "+item.getName(channel));
				     if((ready_flag&key.OP_READ   )!=0) item.onReadable  (channel);
				else if((ready_flag&key.OP_ACCEPT )!=0) item.onAcceptable(channel);
				else if((ready_flag&key.OP_WRITE  )!=0) item.onWritable  (channel);
				else if((ready_flag&key.OP_CONNECT)!=0){
					item.onConnectable(channel);
					try{key.interestOps(key.interestOps()&~key.OP_CONNECT);}catch(Throwable e){logger.log(java.util.logging.Level.WARNING,"OP_CONNECT",e);}
					//	http://developer.java.sun.com/developer/bugParade/bugs/4960791.html
					// 'Using OP_CONNECT with Selector.select causes selector to fire repeatedly'
				}else logger.warning( ready_flag+" "+item.getName(channel) );
			}catch(Throwable e){ logger.log(java.util.logging.Level.WARNING,"selection key",e);}
			// 必要に合わせて OP_WRITE を直す
			try{
				int ops = key.interestOps();
				key.interestOps(item.wantWrite(channel)?(ops|key.OP_WRITE):(ops&~key.OP_WRITE));
			}catch(Throwable e){}
		}
		if(exit_flag){
			for(Iterator it= keys.iterator();it.hasNext();){
				try{
					SelectionKey key = (SelectionKey)it.next();
					SelectorItem item = (SelectorItem)key.attachment();
					SelectableChannel channel=key.channel();
					if(channel==null) continue;
					logger.info( "wait for "
						+item.getClass().getName()
						+" "+
							((channel instanceof SocketChannel       )?((SocketChannel      )channel).socket().getRemoteSocketAddress().toString()
							:(channel instanceof ServerSocketChannel )?((ServerSocketChannel)channel).socket().getLocalSocketAddress ().toString()
							:"")
					);
					item.onSelectorExit(channel);
				}catch(NullPointerException e){
					// do nothing
				}catch(CancelledKeyException e){
					// do nothing
				}catch(java.util.ConcurrentModificationException e){
					// do nothing
				}catch(Throwable e){
					logger.log(java.util.logging.Level.WARNING,"closeAll",e);
				}
			}
		}
		if(now < timer_next){
			timer_next += 1000;
			for(Iterator it= keys.iterator();it.hasNext();){
				SelectionKey key = (SelectionKey)it.next();
				SelectorItem item = (SelectorItem)key.attachment();
				SelectableChannel channel=key.channel();
				try{
					if(channel==null) continue;
					item.onTimer(channel);
				}catch(NullPointerException e){
					// do nothing
				}catch(CancelledKeyException e){
					// do nothing
				}catch(java.util.ConcurrentModificationException e){
					// do nothing
				}catch(Throwable e){
					logger.log(java.util.logging.Level.WARNING,"onTimer",e);
				}
			}
		}
		boolean wantwrite=true;
		if(avail==0|| sps_progress==0){
			wantwrite=false;
			// 全要素のOP_WRITE を直す
			for(Iterator it= keys.iterator();it.hasNext();){
				SelectionKey key = (SelectionKey)it.next();
				SelectorItem item = (SelectorItem)key.attachment();
				SelectableChannel channel=key.channel();
				try{
					if(channel==null) continue;
					boolean ww = item.wantWrite(channel);
					if(ww) wantwrite= true;
					int ops = key.interestOps();
					key.interestOps(ww?(ops|key.OP_WRITE):(ops&~key.OP_WRITE));
				}catch(Throwable e){}
			}
		}
		logger.finest(status+" fps="+sps_count+"/sec step="+step+"ms");
		if(wantwrite){
			step = select_interval_min;
			dmode =false; cost_count =0;
		}else{
			if((step +=(step*select_interval_step)>>8)>select_interval_max) step= select_interval_max;
			// 書くものがないのに高負荷が続くなら詳細表示
			if (++cost_count >300) dmode = true;
		}
		// 定期的にクライアントを追加する
	//	Client.addNew(now,selector);
	}

	public void loop(){
		try{
			selector= Selector.open();
		//	server = new Server(selector);
			while(!exit_flag ){
				if(selector==null){
					try{ selector= Selector.open(); }catch(Throwable e){logger.log(java.util.logging.Level.WARNING,"open selector",e);}
				}
				// 保存したキーを復活させる
				if(saved_keys!=null){
					for( int i=0;i<saved_keys.length;++i){
						Object[] item = saved_keys[i];
						try{
								((SelectableChannel)item[0]).register(selector,((Integer)item[1]).intValue(),item[2]);
						}catch(Throwable e){ logger.log(java.util.logging.Level.WARNING,"regist saved key to selector",e); }
					}
					saved_keys=null;
				}
				step = select_interval_min;
				while( !exit_flag && saved_keys==null ){
					if( selector.keys().isEmpty() ){ my_wait(500); continue; }
					// selectする
					now = System.currentTimeMillis();
					avail =selector.select(step);
					long select_blocked = System.currentTimeMillis()-now;

					/*
						http://developer.java.sun.com/developer/bugParade/bugs/4881228.html
						Selector.select() fails on OP_ACCEPT when the network is unplugged (wxp)
						への対策
					*/	
					if(avail==0 && selector.selectedKeys().size()==0 && step>=300 && select_blocked<50 ){
						logger.severe("network is unplugged?");
						saved_keys = new Object[selector.keys().size()][];
						int i=0;
						for(Iterator it= selector.keys().iterator();it.hasNext();){
							SelectionKey key = (SelectionKey)it.next();
							saved_keys[i++]=new Object[]{ key.channel(),new Integer(key.interestOps()),key.attachment()};
						}
						try{ selector.close(); }catch(Throwable e){logger.log(java.util.logging.Level.WARNING,"temporary close selector",e);}
						selector=null;
						break;
					}

					// 秒間select数
					++sps_progress;
					if(now - sps_before >=1000){
						sps_before +=1000;
						sps_count=sps_progress;
						sps_progress =0;
					}
					javax.swing.SwingUtilities.invokeAndWait(this);
				}
				my_wait(2000);
			}
			exit_flag=true;
			// 登録されたキーが閉じられるのを待つ
			while( !selector.keys().isEmpty() ){
				// selectする
				now = System.currentTimeMillis();
				avail =selector.select(100);
				// 秒間select数
				++sps_progress;
				if(now - sps_before >=1000){
					sps_before +=1000;
					sps_count=sps_progress;
					sps_progress =0;
				}
				javax.swing.SwingUtilities.invokeAndWait(this);
			}
			try{ selector.close(); }catch(Throwable e){ logger.log(java.util.logging.Level.WARNING,"close selector",e); }
			closed = true;
		}catch(Throwable e){
			logger.log(java.util.logging.Level.WARNING,"selector loop",e);
		}
	}

	// チャンネルを登録する
	// (たぶんAWTスレッドから呼ばれる)
	public SelectionKey register(SelectorItem item,SelectableChannel channel,int op) 
	throws java.io.IOException,java.nio.channels.ClosedChannelException
	{ return channel.register(selector,op,item); }

	public SelectionKey register(SelectorItem item,SelectableChannel channel)
	throws java.io.IOException,java.nio.channels.ClosedChannelException
	{ return channel.register(selector,channel.validOps(),item); }
}

/*
public class SelectorRun implements Runnable{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("base.selectorrun");
	static{ logger.setLevel(null); }

	Selector selector;

	// コンストラクタ
	public SelectorRun() throws java.io.IOException {
		selector=Selector.open();
	}

	// checkするスレッドは事前にこれを呼ぶこと
	public void setCheckThreadInfo(){
		// 現状、特にすることはない
	}
	public synchronized void MyWait(long t){ try{ wait(t);}catch(InterruptedException e){} }
	public synchronized void MyNotify(){ notify();}

	// 呼び出し側のスレッドからselectして、後はイベントディスパッチスレッドで処理
	public Throwable check(){
		try{
			if( selector.keys().isEmpty() ){
				MyWait(1000);
			}else{
				selector.select(900);
				javax.swing.SwingUtilities.invokeAndWait(this);
			}
		}catch(InterruptedException e){
			// nothing to do
		}catch(NullPointerException e){
			// nothing to do
		}catch(java.lang.reflect.InvocationTargetException e){
			return e.getCause();
		}catch(Throwable e){
			return e;
		}
		return null;
	}

	// チャンネルを登録する
	// (たぶんAWTスレッドから呼ばれる)
	public SelectionKey register(SelectorItem item,SelectableChannel channel) throws java.io.IOException,java.nio.channels.ClosedChannelException{
		SelectionKey key = channel.register(selector.wakeup(),channel.validOps(),item);
		return key;
	}

	// 待機を解除する
	// (たぶんAWTスレッドから呼ばれる)
	public void wakeup(){
		selector.wakeup();
		if(selector.keys().isEmpty()) MyNotify();
	}

	// アイテムのonTimerを呼ぶ
	// (たぶんAWTスレッドから呼ばれる)
	public void timer(){
		selector.wakeup();
		run();
		for(java.util.Iterator it = selector.keys().iterator();it.hasNext();){
			SelectionKey key = (SelectionKey)it.next();
			SelectorItem item =(SelectorItem)key.attachment();
			SelectableChannel channel=key.channel();
			try{
				if(channel==null) continue;
				item.onTimer(channel);
			}catch(CancelledKeyException e){
				// do nothing
			}catch(java.util.ConcurrentModificationException e){
				// do nothing
			}catch(Throwable e){
				logger.log(java.util.logging.Level.WARNING,"timer",e);
			}
		}
	}

	// implements Runnable
	// (たぶんAWTスレッドから呼ばれる)
	public void run(){
		try{
			selector.selectNow();
		//	if(selector.selectedKeys().size()==0) return;
		//	System.err.println("key count="	+selector.selectedKeys().size()+"/"+selector.keys().size());
			for(java.util.Iterator it = selector.selectedKeys().iterator();it.hasNext();){
				SelectionKey key = (SelectionKey)it.next();
				SelectorItem item =(SelectorItem)key.attachment();
				SelectableChannel channel=key.channel();
			//	System.err.println(item.getClass().getName()+" " +(key.isAcceptable ()?"a":"") +(key.isConnectable ()?"c":"") +(key.isReadable ()?"r":"") +(key.isWritable ()?"w":"") );
				try{
					if(key.isAcceptable () && item.onAcceptable (channel)){ it.remove(); continue;}
					if(key.isConnectable() && item.onConnectable(channel)){ it.remove(); continue;}
					if(key.isReadable   () && item.onReadable   (channel)){ it.remove(); continue;}
					if(key.isWritable   () && item.onWritable   (channel)){ it.remove(); continue;}
				}catch(CancelledKeyException e){
					// do nothing
				}catch(java.util.ConcurrentModificationException e){
					// do nothing
				}catch(Throwable e){
					logger.log(java.util.logging.Level.WARNING,"run",e);
				}
			}
		}catch(Throwable e){ logger.log(java.util.logging.Level.WARNING,"run(2)",e); }
	}

	// 登録されたキーがすべて閉じられるのを待つ
	// (たぶんAWTスレッドから呼ばれる)
	public boolean closeAll(){
		wakeup();
		run();
		if( selector.keys().isEmpty() ){
			logger.fine( "all selector keys are closed.");
			return true;
		}
		for(java.util.Iterator it = selector.keys().iterator();it.hasNext();){
			SelectionKey key = (SelectionKey)it.next();
			SelectorItem item =(SelectorItem)key.attachment();
			SelectableChannel channel=key.channel();
			try{
				if(channel==null) continue;
				logger.fine( "wait for "
					+item.getClass().getName()
					+" "+((channel instanceof SocketChannel)?((SocketChannel)channel).socket().getRemoteSocketAddress().toString():"")
				);
				item.onSelectorExit(channel);
				item.onTimer(channel);
			}catch(NullPointerException e){
				// do nothing
			}catch(CancelledKeyException e){
				// do nothing
			}catch(java.util.ConcurrentModificationException e){
				// do nothing
			}catch(Throwable e){
				logger.log(java.util.logging.Level.WARNING,"closeAll",e);
			}
		}
		return false;
	}
}
*/

