// UTF-8 ☀☁☂☃
package bluntirc; 
/*
	ログファイル出力の遅延
*/
import java.util.*;
import java.io.*;

public class DelayLog{
	static class PerLine{
		long add_time;
		byte[] line;
	};
	static class PerFile{
		long last_used;
		LinkedList lines = new LinkedList();
	};
	private HashMap map=new HashMap();
	private long last_cleanup=0;

	// 使用されていないマップエントリを消す間隔 ミリ秒
	private static final long SweepInterval = 3600000;

	public void add(File f,byte[] data){
		long now = System.currentTimeMillis();
		PerFile pf = (PerFile)map.get(f);
		if(pf==null) map.put(f,pf=new PerFile());
		if(pf.lines.size()==0) pf.last_used = now;
		pf.lines.addLast(data);
		if(pf.lines.size() > App.root_property.setDefaultInt("DelayLog/MaxLine",100) ) flush(f,pf,now);
		if( now - last_cleanup >=SweepInterval ){
			last_cleanup=now;
			sweep(now);
		}
	}
	void sweep(long now){
		for(Iterator it=map.entrySet().iterator();it.hasNext();){
			Map.Entry me = (Map.Entry)it.next();
			File key=(File)me.getKey();
			PerFile pf=(PerFile)me.getValue();
			if(pf.lines.size()==0 && now- pf.last_used >= SweepInterval ){
				it.remove();
			}
		}
	}

	public void onTimer(){
		long now = System.currentTimeMillis();
		long max_time = App.root_property.setDefaultInt("DelayLog/MaxTime",60000);
		for(Iterator it=map.entrySet().iterator();it.hasNext();){
			Map.Entry me = (Map.Entry)it.next();
			File key=(File)me.getKey();
			PerFile pf=(PerFile)me.getValue();
			if(pf.lines.size()==0) continue;
			if(now- pf.last_used > max_time ) flush(key,pf,now);
		}
	}

	void flush(File f,PerFile pf,long now){
		try{
			FileOutputStream fos= new FileOutputStream(f,true);
			try{
				for(Iterator it=pf.lines.iterator();it.hasNext();){
					fos.write((byte[])it.next());
				}
			}finally{
				fos.close();
			}
		}catch(SecurityException e){
			App.Log(f.getAbsolutePath()+"への出力はセキュリティマネージャによって拒否された。"+e.getLocalizedMessage());
		}catch(FileNotFoundException e){
			App.Log("ログファイルの出力に指定したファイル名"+f.getAbsolutePath()+"を開くことができない。"+e.getLocalizedMessage());
		}catch(UnsupportedEncodingException e){
			App.Log("ログファイル"+f.getAbsolutePath()+"への出力に指定した文字エンコーディング"+App.root_property.getString("LogFileEncoding")+"はこのシステムではサポートされていない。"+e.getLocalizedMessage());
		}catch(IOException e){
			App.Log("ログファイル"+f.getAbsolutePath()+"への出力は失敗した。"+e.getLocalizedMessage());
		}catch(Throwable e){
			App.Log("ログファイル"+f.getAbsolutePath()+"への出力は失敗した。"+e.getLocalizedMessage());
		}finally{
			pf.lines.clear();
			pf.last_used=now;
		}
	}
	public void flushAll(){
		long now = System.currentTimeMillis();
		for(Iterator it=map.entrySet().iterator();it.hasNext();){
			Map.Entry me = (Map.Entry)it.next();
			File key=(File)me.getKey();
			PerFile pf=(PerFile)me.getValue();
			flush(key,pf,now);
		}
	}
}
