package bluntirc;
import gui.*;
import java.util.*;
import java.io.*;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.Action;

public class FontInfoClickable 
extends FontInfo2 
implements buffer.BufferClickAdapter
{
	public FontInfoClickable(String name){ this.name=name;}
	public boolean nohover=false;
	public String click_action;
	public String name;
	public String popup_name;

	Integer ascent_plus =new Integer(0);
	Integer descent_plus=new Integer(0);
	Integer leading_plus=new Integer(0);
	Cursor cursor =new Cursor(Cursor.TEXT_CURSOR);
	public Object get(int key){
		switch(key){
		case KEY_BCA        :return this;
		case KEY_NOHOVER    :return nohover?this:null;
		case KEY_MENUSTRING :return popup_name;
		case KEY_NAME       :return name;
		case KEY_ASCENTPLUS :return ascent_plus ;
		case KEY_DESCENTPLUS:return descent_plus;
		case KEY_LEADINGPLUS:return leading_plus;
		case KEY_CURSOR: return cursor;
		}
		return super.get(key);
	}

	public boolean ClickEvent(MouseEvent e,buffer.LogDocument document,buffer.TextSpanInfo pos){
		if(click_action==null){
			App.logger.finest(name+" has no click action");
			return false;
		}
		Action a= App.action_manager.find(click_action);
		if(a==null){
			App.Log("ClickEvent: no action for keyword"+click_action);
			return false;
		}
		return ( null != App.action_manager.call(a,new Object[]{e,document,pos}) );
	}
}
