package bluntirc;
// UTF-8 このファイルはUTF-8で書かれています。
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Container;
import java.awt.BorderLayout;
//import java.awt.*;
import java.awt.event.*;

class StackItem{
	Object o;
	String caption;
	public StackItem(Object o,String caption){
		this.o=o;this.caption=caption;
	}
}

public class PropertyInspector
extends JFrame
{
	public static JPanel newJPanel(){
		JPanel p=new JPanel();
		p.setLayout(new BorderLayout());
		return p;
	}

	public static void addComponent
	(Container c,GridBagLayout gbl,GridBagConstraints gbc,Component item)
	{ gbl.setConstraints(item,gbc); c.add(item); }

	JTextField ItemName=new JTextField();
	JButton b_up= new JButton("上へ");
	JButton b_reload = new JButton("再読み込み");

	Container root;

	JPanel panel_O=newJPanel();
	JTextArea jtaObject=new JTextArea();

	JPanel panel_S=newJPanel();
	JTextField jtfStringValue =new JTextField();
	JButton b_setStringValue =new JButton("変更");

	JPanel panel_L=newJPanel();
	java.awt.List lList=new java.awt.List();
	JButton btnListDive =new JButton("編集");
	JButton btnListRemove =new JButton("削除");
	ButtonGroup bgListItemType=new ButtonGroup();
	JTextField tfListString =new JTextField();
	JButton jbNewListElement=new JButton("追加");

	JPanel panel_T=newJPanel();
	java.awt.List lHash=new java.awt.List();
	JButton btnHashDive =new JButton("項目の詳細");
	JButton btnHashRemove =new JButton("削除");
	JTextField tfHashKey=new JTextField();
	JTextField tfHashValue =new JTextField();
	ButtonGroup bgHashItemType=new ButtonGroup();
	JButton jbNewHashElement=new JButton("追加");

	void initGUI(){
		root = getContentPane();
		root.setLayout(new BorderLayout());
		// ダイアログ上部は 編集中の項目名と上へのボタン
		{
			JPanel p=newJPanel();
				Box btns = Box.createHorizontalBox();
				btns.add(b_up);
				btns.add(b_reload);
				p.add(btns,BorderLayout.EAST);
			p.add(ItemName,BorderLayout.CENTER);
			root.add(p,BorderLayout.NORTH);
		}
		// オブジェクト閲覧
		{
			panel_O.add( jtaObject,BorderLayout.CENTER);
		}

		// 文字列編集のパネル
		{
			Box b=Box.createVerticalBox();
			b.add(jtfStringValue);
				Box btns = Box.createHorizontalBox();
				btns.add(Box.createHorizontalGlue());
				btns.add( b_setStringValue );
				b.add(btns);
			panel_S.add(b,BorderLayout.NORTH);
			panel_S.add(newJPanel(),BorderLayout.CENTER);
		}
		// リスト編集のパネル
		{
			panel_L.add(lList,BorderLayout.CENTER);
			Box b= Box.createVerticalBox();
				Box btns = Box.createHorizontalBox();
				btns.add( btnListDive );
				btns.add( btnListRemove);
				btns.add(Box.createHorizontalGlue());
				b.add(btns);
			// リストに要素を追加するパネル
			JPanel p_new = newJPanel();
			{
				p_new.setBorder(BorderFactory.createTitledBorder("項目の追加"));
				GridBagLayout gbl = new GridBagLayout();
				GridBagConstraints gbc = new GridBagConstraints();
				p_new.setLayout(gbl);

				String[] type=new String[]{ "new String","new List","new Map"};
				JRadioButton[] jrb=new JRadioButton[type.length];
				for(int i=0;i<type.length;++i){
					jrb[i]=new JRadioButton(type[i]);
					if(i==0&& !allowAddString) jrb[i].setEnabled(false);
					if(i==1&& !allowAddList) jrb[i].setEnabled(false);
					if(i==2&& !allowAddMap) jrb[i].setEnabled(false);
					bgListItemType.add(jrb[i]);
					jrb[i].addItemListener(new ItemListener(){
						public void itemStateChanged(ItemEvent e){ll_checkButtonState();}
					});
				}
				//
				gbc.anchor=GridBagConstraints.WEST ;
				gbc.fill=GridBagConstraints.HORIZONTAL;
				addComponent(p_new,gbl,gbc,jrb[0]);
				gbc.gridwidth=GridBagConstraints.REMAINDER;
				gbc.weightx=1;
				addComponent(p_new,gbl,gbc,tfListString);
				gbc.weightx=0;
				//
				for(int i=1;i<type.length;++i){
				gbc.gridwidth=GridBagConstraints.REMAINDER;
					addComponent(p_new,gbl,gbc,jrb[i]);
				}
				//
				gbc.fill=GridBagConstraints.NONE;
				addComponent(p_new,gbl,gbc,jbNewListElement);
			}
			b.add(p_new);
			panel_L.add(b,BorderLayout.SOUTH);
		}

		// Mapの編集画面
		{
			panel_T.add(lHash,BorderLayout.CENTER);
			Box b= Box.createVerticalBox();
				Box btns = Box.createHorizontalBox();
				btns.add( btnHashDive );
				btns.add( btnHashRemove);
				btns.add(Box.createHorizontalGlue());
				b.add(btns);
			// ハッシュに要素を追加するパネル
			JPanel p_new = newJPanel();
			{
				p_new.setBorder(BorderFactory.createTitledBorder("項目の追加"));
				GridBagLayout gbl = new GridBagLayout();
				GridBagConstraints gbc = new GridBagConstraints();
				p_new.setLayout(gbl);

				String[] type=new String[]{ "new String","new List","new Map"};
				JRadioButton[] jrb=new JRadioButton[type.length];
				
				for(int i=0;i<type.length;++i){
					jrb[i]=new JRadioButton(type[i]);
					if(i==0&& !allowAddString) jrb[i].setEnabled(false);
					if(i==1&& !allowAddList) jrb[i].setEnabled(false);
					if(i==2&& !allowAddMap) jrb[i].setEnabled(false);
					bgHashItemType.add(jrb[i]);
					jrb[i].addItemListener(new ItemListener(){
						public void itemStateChanged(ItemEvent e){tm_checkButtonState();}
					});
				}
				gbc.anchor=GridBagConstraints.WEST ;
				gbc.fill=GridBagConstraints.HORIZONTAL;
				addComponent(p_new,gbl,gbc,new JLabel("キー"));
				gbc.gridwidth=GridBagConstraints.REMAINDER;
				gbc.weightx=1;
				addComponent(p_new,gbl,gbc,tfHashKey);
				gbc.weightx=0;
				gbc.gridwidth=GridBagConstraints.RELATIVE ;
				//
				addComponent(p_new,gbl,gbc,jrb[0]);
				gbc.gridwidth=GridBagConstraints.REMAINDER;
				gbc.weightx=1;
				addComponent(p_new,gbl,gbc,tfHashValue);
				gbc.weightx=0;
				//
				for(int i=1;i<type.length;++i){
					addComponent(p_new,gbl,gbc,jrb[i]);
				gbc.gridwidth=GridBagConstraints.REMAINDER;
				}
				//
				gbc.fill=GridBagConstraints.NONE;
				addComponent(p_new,gbl,gbc,jbNewHashElement);
			}
			b.add(p_new);
			panel_T.add(b,BorderLayout.SOUTH);
		}
		///////////////////////////
		ItemName.setEditable(false);
		jtaObject.setEditable(false);
		jtaObject.setEnabled(false);

		Component[] texts = new Component[]{
tfListString,
jtfStringValue,
tfHashKey,
tfHashValue,
lList,
lHash,
jtaObject,
ItemName,
		};
		for(int i=0;i<texts.length;++i)
		{ texts[i].setFont(new Font("ＭＳ ゴシック",Font.PLAIN,16)); }


		b_up.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				if(stack.size()>1 && stack.size()>fakeRoot){
					stack.removeLast();
					resetPanels();
				}
			}
		});
		b_reload.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				resetPanels();
			}
		});
		//////////////////////
		// String の編集
		b_setStringValue.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				String caption = ((StackItem)stack.getLast()).caption;
				Object o = ((StackItem)stack.get(stack.size()-2)).o;
				if(o instanceof Map){
					Map tm=((Map)o);
					if(tm.get(caption) != old_string_addr ){
						App.logger.warning("親のMapが別の所から変更されています。読み直します。");
						((StackItem)stack.getLast()).o = tm.get(caption);
					}else{
						property.set(TargetName,jtfStringValue.getText());
					}
				}else if(o instanceof List){
					List ll = ((List)o);
					int index=-1;
					try{
						index = Integer.parseInt(caption);
					}catch(Throwable ex){}
					if(index <0 || index >= ll.size()
					|| ll.get(index) != old_string_addr
					){
						App.logger.warning("親のListが別の所から変更されています。");
					}else{
						property.set(TargetName,jtfStringValue.getText());
					}
				}
				stack.removeLast();
				resetPanels();
			}
		});
		///////////////////////////
		// Listの編集
		lList.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e){ll_checkButtonState();}
		});
		lList.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				ll_checkButtonState();
				if(btnListDive.isEnabled()){
					Object key   =ll_getSelectedIndex();
					Object value =ll_getSelectedValue();
					dive(value,(String)key);
				}
			}
		});
		btnListDive.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				ll_checkButtonState();
				if(btnListDive.isEnabled()){
					Object key   =ll_getSelectedIndex();
					Object value =ll_getSelectedValue();
					dive(value,(String)key);
				}
			}
		});
		btnListRemove.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				ll_checkButtonState();
				if(btnListRemove.isEnabled()) ll_removeSelected();
			}
		});
		jbNewListElement.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				ll_checkButtonState();
				if(jbNewListElement.isEnabled()) llListItem_add();
			}
		});

		///////////////////////////
		// Map の編集
		lHash.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e){tm_checkButtonState();}
		});
		lHash.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				tm_checkButtonState();
				if(btnHashDive.isEnabled()){
					Object key=tm_getSelectedKey();
					Object value=tm_getSelectedValue();
					dive(value,(String)key);
				}
			}
		});
		tfHashKey.getDocument().addDocumentListener(new DocumentListener(){
			public void changedUpdate(DocumentEvent e){tm_checkButtonState();}
			public void insertUpdate (DocumentEvent e){tm_checkButtonState();}
			public void removeUpdate (DocumentEvent e){tm_checkButtonState();}
		});
		btnHashDive.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				tm_checkButtonState();
				if(btnHashDive.isEnabled()){
					Object key=tm_getSelectedKey();
					Object value=tm_getSelectedValue();
					dive(value,(String)key);
				}
			}
		});
		btnHashRemove.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				tm_checkButtonState();
				if(btnHashRemove.isEnabled()) tm_removeSelected();
				tm_checkButtonState();
			}
		});
		jbNewHashElement.addActionListener(new AbstractAction(){
			public void actionPerformed(ActionEvent e){
				tm_checkButtonState();
				if(jbNewHashElement.isEnabled()) tfHashKey_add();
				tm_checkButtonState();
			}
		});
	}

	///////////////////////////////////
	void objectTarget_init(){
		Object o = property.get(TargetName);
		jtaObject.setText(o.toString());
	}

	///////////////////////////////////
	String old_string_addr;
	void ssTarget_init(){
		String s = (String)property.get(TargetName);
		old_string_addr = s;
		jtfStringValue.setText(s);
	}

	///////////////////////////////////

	void llTarget_init(){
		lList.removeAll();
		Object o = property.get(TargetName);
		if( ! (o instanceof List)){
			stack.removeLast();
			resetPanels();
			return;
		}
		int size = ((List)o).size();
		for(int i=0;i<size;++i){
			Object value = ((List)o).get(i);
			lList.add(ll_getDesc(i,value));
		}
		ll_checkButtonState();
	}
	String ll_getDesc(int i,Object value){
		return "["+i+"]"+getDesc(value);
	}
	void ll_checkButtonState(){
		boolean selected_flag = false;
		int i= lList.getSelectedIndex();
		if(i>=0){
			if(! lList.getItem(i).equals(ll_getDesc(i,property.get(mergeVector(TargetName,""+i ))))
			){
				App.logger.warning("リストが別の所から更新されているようです。読み直します。");
				resetPanels();
				return;
			}
			selected_flag = true;
		}
		btnListRemove.setEnabled(selected_flag);
		if(selected_flag){
			Object o = property.get(mergeVector(TargetName,""+i) );
			if( o ==null) selected_flag=false;
		}
		btnListDive.setEnabled(selected_flag);
		selected_flag=false;
		int selected =-1;
		i=0;
		for( Enumeration e = bgListItemType.getElements() ; e.hasMoreElements();){
			JRadioButton rb=(JRadioButton)e.nextElement();
			if(rb.isSelected()){
				selected=i;
				selected_flag=true;
				break;
			}
			++i;
		}
		tfListString.setEditable(selected==0);
		jbNewListElement.setEnabled( selected_flag );
	}
	Object ll_getSelectedIndex(){
		int i= lList.getSelectedIndex();
		if(i<0) return null;
		return ""+i;
	}
	Object ll_getSelectedValue(){
		int i= lList.getSelectedIndex();
		if(i<0) return null;
		return property.get(mergeVector(TargetName,""+i) );
	}
	void ll_removeSelected(){
		int i= lList.getSelectedIndex();
		if(i<0) return;
		Object o = property.get(TargetName);
		if( ! (o instanceof List)
		||  i>= ((List)o).size()
		){
			stack.removeLast();
			resetPanels();
			return;
		}
		((List)o).remove(i);
		lList.remove(i);
	}
	void llListItem_add(){
		Object value=null;
		int i=0;
		for( Enumeration e = bgListItemType.getElements() ; e.hasMoreElements();){
			JRadioButton rb=(JRadioButton)e.nextElement();
			if(rb.isSelected()){
				switch(i){
				case 0: value = tfListString.getText(); break;
				case 1: value = new LinkedList(); break;
				case 2: value = new HashMap(); break;
				}
				break;
			}
			++i;
		}
		if(value==null) return;
		Object o = property.get(TargetName);
		if(!(o instanceof List)){
			stack.removeLast();
			resetPanels();
			return;
		}
		((List)o).add(value);
		lList.add( ll_getDesc(((List)o).size()-1,value));
	}

	///////////////////////////////////
	PropertyManager property;
	Vector TargetName;
	Vector mergeVector(Vector v,Object key){
		Vector v2= (Vector)v.clone();
		v2.add(key);
		return v2;
	}

	///////////////////////////////////

	LinkedList lHash_key = new LinkedList();
	void tmTarget_init(){
		lHash.removeAll();
		Object map = property.get(TargetName);
		if(!(map instanceof Map)){
			stack.removeLast();
			resetPanels();
			return;
		}
		// キーの一覧をソート
		lHash_key.clear();
		for(Iterator it=((Map)map).keySet().iterator();it.hasNext();)
		{ lHash_key.add(it.next()); }
		Collections.sort(lHash_key);
		// 表示リストとキーリストを作る
		for(Iterator it=lHash_key.iterator();it.hasNext();){
			String key;
			Object value = ((Map)map).get( key=(String)it.next() );
			lHash.add( tm_getDesc(key,value));
		}
		tm_checkButtonState();
	}
	String tm_getDesc(Object key,Object value){
		return "{"+ (String)key +"} is "+ getDesc(value);
	}
	void tm_checkButtonState(){
		boolean selected_flag = false;
		int i= lHash.getSelectedIndex();
		String key=null;
		if(i>=0){
			key = (String)lHash_key.get(i);
			// いつのまにか削除されてたらしい
			if(! property.exists(mergeVector(TargetName,key) )
			){
				lHash.remove(i);
				lHash_key.remove(i);
				tm_checkButtonState();
				return;
			}
			selected_flag = true;
		}
		btnHashRemove.setEnabled(selected_flag);
		if(selected_flag){
			Object o = property.get(mergeVector(TargetName,key));
			if( o==null) selected_flag=false;
		}
		btnHashDive.setEnabled(selected_flag);
		// 追加ボタンの有効状態
		selected_flag=false;
		i=0;
		int selected =-1;
		for( Enumeration e = bgHashItemType.getElements() ; e.hasMoreElements();){
			JRadioButton rb=(JRadioButton)e.nextElement();
			if(rb.isSelected()){
				selected=i;
				selected_flag=true;
				break;
			}
			++i;
		}
		tfHashValue.setEditable(selected==0);
		jbNewHashElement.setEnabled( selected_flag 
		&& !property.exists(
			mergeVector(TargetName,tfHashKey.getText()) )
		);
	}
	Object tm_getSelectedKey(){
		int i= lHash.getSelectedIndex();
		if(i<0) return null;
		return lHash_key.get(i);
	}
	Object tm_getSelectedValue(){
		int i= lHash.getSelectedIndex();
		if(i<0) return null;
		return property.get(mergeVector(TargetName,lHash_key.get(i)));
	}
	void tm_removeSelected(){
		int i= lHash.getSelectedIndex();
		if(i<0) return;
		Object map = property.get(TargetName);
		if(!(map instanceof Map)){
			stack.removeLast();
			resetPanels();
			return;
		}
		((Map)map).remove(lHash_key.get(i));
		lHash.remove(i);
		lHash_key.remove(i);
	}
	void tfHashKey_add(){
		String key = tfHashKey.getText();
		Object value=null;
		int i=0;
		for( Enumeration e = bgHashItemType.getElements() ; e.hasMoreElements();){
			JRadioButton rb=(JRadioButton)e.nextElement();
			if(rb.isSelected()){
				switch(i){
				case 0:value = tfHashValue.getText();break;
				case 1:value = new LinkedList();break;
				case 2:value = new HashMap(); break;
				}
				break;
			}
			++i;
		}
		if(value==null) return;
		property.set(mergeVector(TargetName,key),value);
		lHash.add( tm_getDesc(key,value));
		lHash_key.add(key);
	}

	//////////////////////////////////////////////
	java.awt.Component now_type;
	void resetPanels(){
		// 注目している項目の情報
		{
			b_up.setEnabled( stack.size()>1 && stack.size()>fakeRoot);
			StringBuffer sb=new StringBuffer();
			TargetName = new Vector();
			StringBuffer st=new StringBuffer();
			Object pre=null;
			for(int i=0;i<stack.size();++i){
				StackItem si = (StackItem)stack.get(i);
				if(pre==null){
					if( detailInCaption || i==0 ) sb.append(si.caption);
				}else if( pre instanceof Map){
					if( detailInCaption || i==0 ) sb.append('{');
					if( detailInCaption || i==0 ) sb.append(si.caption);
					if( detailInCaption || i==0 ) sb.append('}');
					TargetName.add(si.caption);
				}else if( pre instanceof List){
					if( detailInCaption || i==0 ) sb.append('[');
					if( detailInCaption || i==0 ) sb.append(si.caption);
					if( detailInCaption || i==0 ) sb.append(']');
					TargetName.add(si.caption);
				}
				pre=si.o;
			}
			if( detailInCaption){
				sb.append(" is ");
				if( pre instanceof String) sb.append("String");
				else if( pre instanceof Map) sb.append("Map");
				else if( pre instanceof List) sb.append("List");
				else sb.append(pre.getClass().getName());
			}
			ItemName.setText(sb.toString());
		}

		if(now_type!=null){
			root.remove(now_type);
			now_type=null;
		}
		StackItem si = (StackItem)stack.getLast();
		if(si.o instanceof String){
			ssTarget_init();
			root.add(now_type=panel_S,java.awt.BorderLayout.CENTER);
		}else if(si.o instanceof List){
			llTarget_init();
			root.add(now_type=panel_L,java.awt.BorderLayout.CENTER);
		}else if(si.o instanceof Map){
			tmTarget_init();
			root.add(now_type=panel_T,java.awt.BorderLayout.CENTER);
		}else{
			objectTarget_init();
			root.add(now_type=panel_O,java.awt.BorderLayout.CENTER);
		}
		now_type.invalidate();
		root.invalidate();
		root.validate();
		root.repaint();
	}
	//////////////////////////////////////////////
	LinkedList stack = new LinkedList();

	String getDesc(Object value){
		if(value==null) return "null";
		if(value instanceof String) return "String "+value.toString();
		if(value instanceof List) return "List size="+((List)value).size();
		if(value instanceof Map) return "Map size="+((Map)value).size();
		return value.getClass().getName();
	}

	public void dive(Object o,String caption){
		if( o !=null){
			stack.add(new StackItem(o,caption));
			resetPanels();
		}
	}
	public PropertyInspector(PropertyManager p,String caption){
		super("プロパティ インスペクタ "+caption);
		setIconImage( App.getApp().icon_app.getImage() );
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		property=p;
		stack.add(new StackItem(property.get(""),caption));
		initGUI();
		resetPanels();
		pack();
		show();
	}

	boolean allowAddString = true;
	boolean allowAddList   = true;
	boolean allowAddMap    = true;
	boolean detailInCaption =true;
	int fakeRoot = 1;
	public PropertyInspector(PropertyManager p,String caption,String name,boolean allowAddString,boolean allowAddList,boolean allowAddMap){
		super(caption+" - プロパティインスペクタ ");

		this.allowAddString=allowAddString;
		this.allowAddList  =allowAddList  ;
		this.allowAddMap   =allowAddMap   ;
		detailInCaption = (allowAddList || allowAddMap );

		setIconImage( App.getApp().icon_app.getImage() );
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		property=p;
		stack.add(new StackItem(property.get(""),caption));
		Vector param = PropertyManager.parsePropertyName(name);
		{
			Object context = property.get("");
			for(int i=0;i<param.size();++i){
				String v = (String)param.get(i);
				if(context instanceof Map){
					context = ((Map)context).get(v);
					if(context==null) break;
					stack.add(new StackItem(context,v));
					++fakeRoot;
					continue;
				}
				if(context instanceof List){
					int index ;
					try{
						index= Integer.parseInt(v);
					}catch(Throwable e){
						App.Log(v+" リストのインデクスは数値でないといけません");
						context=null; break;
					}
					if( index<0 || index>=((List)context).size() ){
						App.Log(v+" リストのインデクスが範囲外です");
						context=null; break;
					}
					context = ((List)context).get(index);
					if(context==null) break;
					stack.add(new StackItem(context,v));
					++fakeRoot;
					continue;
				}
				context=null;
				break;
			}
			if(context==null){
				App.Log("name はListでもMapでもありません");
				dispose();
				return;
			}
		}
		initGUI();
		resetPanels();
		pack();
		WindowPos.setWindowsPosToCenter(this);
		show();
	}
}
