package bluntirc;
import gui.*;
import java.util.*;
import java.io.*;
import java.text.*;
import java.awt.*;

// 主にPrintFormatToTextSpanから呼ばれる
public class StyleManager extends buffer.StyleID{
	///////////////////////////////////
	// StyleID  abstract method implement
	public FontInfo2 findBaseStyle(String name){ return findTextStyle(name);}
	public Color4 findCTCPColor(int fg,int bg){
		if(bg!=-1) return new Color4(color_ary[fg],color_ary[bg]);
		return new Color4(color_ary[fg]);
	}
	public static Color[] color_ary=new Color[]{
		new Color(255,255,255), //00  白  
		new Color(0,0,0),		//01  黒  
		new Color(0,0,128),		//02  暗青
		new Color(0,128,0),		//03  暗緑

		new Color(255,0,0),		//04  赤  
		new Color(128,0,0),		//05  暗赤
		new Color(128,0,128),	//06  暗紫
		new Color(255,128,0),	//07  橙  

		new Color(255,255,0),	//08  黄  
		new Color(0,255,0),		//09  緑  
		new Color(0,128,128),	//10  暗水
		new Color(0,255,255),	//11  水  

		new Color(0,0,255),		//12  青  
		new Color(255,0,255),	//13  紫  
		new Color(128,128,128),	//14  暗灰
		new Color(192,192,192),	//15  灰色
	};

	///////////////////////////////////

	HashMap config  =new HashMap();
//	public void putTextStyle(String key,FontInfo2 value){ config.put(key,value);}
	public StyleManager(){
		// デフォルトのスタイルを設定
		FontInfo2.setDefaultStyle( def_text);
	}

	private BGInfo def_bg = new BGInfo(SystemColor.window,null);
	public BGInfo findBGInfo(String key){
		Object o= config.get(key);
		if(o instanceof BGInfo) return (BGInfo)o;
		// このへんでApp.Logを使うとスタイル探しの無限ループ
		App.logger.finest("findBGInfo:"+key+" は"+(o!=null?"BGInfoではない":"見つからない"));
		return def_bg;
	}
	private FontInfo2 def_text = new FontInfo2( Color.black,null,Color.white,"Dialog",0,12 );
	public FontInfo2 findTextStyle(String key){
		Object o= config.get(key);
		if(o instanceof FontInfo2){
			FontInfo2  fi=(FontInfo2)o;
			return (FontInfo2)o;
		}
		App.logger.finest("findTextStyle:"+key+" は"+(o!=null?"TextStyleではない":"見つからない"));
		return def_text;
	}
	// 互換性のために用意
	public FontInfo findFontInfo(String key){
		FontInfo2 src = findTextStyle(key);
		FontInfo f=new FontInfo(src.color.fg, src.color.bg, src.color.fg2
			,new Font(src.getFontName(),(src.getFontStyle()&FontInfo2.BASIC_MASK) ,src.getFontSize() )
		);
		f.bg2=src.color.bg2;
		return f;
	}

	///////////////////////////////////////////////////////
	// 設定を読む
	public final static char QUOTE = '\'';
	public final static char DOUBLE_QUOTE = '"';

	public static Color readColor(String cname)
	throws ParseException
	{
		if( cname==null 
		||  cname.length() ==0 
		||  "-".equals(cname) 
		) return null;
		if( cname.charAt(0) != '#' ){
			if(!SystemColorLookUpTable.find(cname))
				throw new ParseException("色指定"+cname+"は未定義です",0);
			return SystemColorLookUpTable.result;
		}
		int[] ir=new int[6];
		if( cname.length()!= 7
		|| -1 == (ir[0]=Character.digit(cname.charAt(1),16))
		|| -1 == (ir[1]=Character.digit(cname.charAt(2),16))
		|| -1 == (ir[2]=Character.digit(cname.charAt(3),16))
		|| -1 == (ir[3]=Character.digit(cname.charAt(4),16))
		|| -1 == (ir[4]=Character.digit(cname.charAt(5),16))
		|| -1 == (ir[5]=Character.digit(cname.charAt(6),16))
		) throw new ParseException("色指定"+cname+"が#HHHHHHの形式ではない",0);

		return new Color(
			 (ir[0]*16+ir[1])/(float)255
			,(ir[2]*16+ir[3])/(float)255
			,(ir[4]*16+ir[5])/(float)255
		);
	}

	public static void setStyleBit(FontInfo2 fi,String value,int mask)
	throws ParseException 
	{
		if(value==null) return;
		value = value.toLowerCase();
		     if(value.equals("1"		)) fi.setStyleBit(mask ,0,1);
		else if(value.equals("0"		)) fi.setStyleBit(mask ,0,0);
		else if(value.equals("on"		)) fi.setStyleBit(mask ,0,1);
		else if(value.equals("off"		)) fi.setStyleBit(mask ,0,0);
		else if(value.equals("inherit"	)) fi.setStyleBit(mask ,1,0);
		else if(value.equals("xor"		)) fi.setStyleBit(mask ,1,1);
		else throw new ParseException("スタイル指定の値"+value+"がおかしい",0);
	}

	static Integer toInteger(String s){
		if(s==null || s.length()==0) return new Integer(0);
		return new Integer(s);
	}
	static void readStyleOption(FontInfoClickable fi,base.MyStreamTokenizer in)
	throws IOException,ParseException
	{
		if(fi.color.bg2==null) fi.color.bg2=fi.color.fg;
		for(Iterator it=in.readOptions("オプション指定",true).entrySet().iterator();it.hasNext();){
			Map.Entry me= (Map.Entry)it.next();
			     if(me.getKey().equals("clickaction")) fi.click_action=(String)me.getValue();
			else if(me.getKey().equals("nohover")) fi.nohover = (null!=me.getValue());
			else if(me.getKey().equals("bold"     )) setStyleBit(fi,(String)me.getValue(),FontInfo2.BOLD     );
			else if(me.getKey().equals("italic"   )) setStyleBit(fi,(String)me.getValue(),FontInfo2.ITALIC   );
			else if(me.getKey().equals("underline")) setStyleBit(fi,(String)me.getValue(),FontInfo2.UNDERLINE);
			else if(me.getKey().equals("reverse"  )) setStyleBit(fi,(String)me.getValue(),FontInfo2.REVERSE  );
			else if(me.getKey().equals("strike"   )) setStyleBit(fi,(String)me.getValue(),FontInfo2.STRIKE   );
			else if(me.getKey().equals("popupmenu"   )) fi.popup_name=(String)me.getValue();

			else if(me.getKey().equals("ascent_plus"    )) fi.ascent_plus =toInteger((String)me.getValue());
			else if(me.getKey().equals("descent_plus"   )) fi.descent_plus=toInteger((String)me.getValue());
			else if(me.getKey().equals("leading_plus"   )) fi.leading_plus=toInteger((String)me.getValue());
			else if(me.getKey().equals("cursor"   )){
					String value = ((String)me.getValue()).toLowerCase();
				if(value.equals("crosshair")) fi.cursor=new Cursor(Cursor.CROSSHAIR_CURSOR);
				else if(value.equals("default")) fi.cursor=new Cursor(Cursor.DEFAULT_CURSOR);
				else if(value.equals("e_resize")) fi.cursor=new Cursor(Cursor.E_RESIZE_CURSOR);
				else if(value.equals("hand")) fi.cursor=new Cursor(Cursor.HAND_CURSOR);
				else if(value.equals("move")) fi.cursor=new Cursor(Cursor.MOVE_CURSOR);
				else if(value.equals("n_resize")) fi.cursor=new Cursor(Cursor.N_RESIZE_CURSOR);
				else if(value.equals("ne_resize")) fi.cursor=new Cursor(Cursor.NE_RESIZE_CURSOR);
				else if(value.equals("nw_resize")) fi.cursor=new Cursor(Cursor.NW_RESIZE_CURSOR);
				else if(value.equals("s_resize")) fi.cursor=new Cursor(Cursor.S_RESIZE_CURSOR);
				else if(value.equals("se_resize")) fi.cursor=new Cursor(Cursor.SE_RESIZE_CURSOR);
				else if(value.equals("sw_resize")) fi.cursor=new Cursor(Cursor.SW_RESIZE_CURSOR);
				else if(value.equals("text")) fi.cursor=new Cursor(Cursor.TEXT_CURSOR);
				else if(value.equals("w_resize")) fi.cursor=new Cursor(Cursor.W_RESIZE_CURSOR);
				else if(value.equals("wait")) fi.cursor=new Cursor(Cursor.WAIT_CURSOR);
				else throw new ParseException(fi.name+"のオプション"+me.getKey()+"の指定"+value+"はtypoか何かだと思う",0);
			}
			else throw new ParseException(fi.name+"のオプション"+me.getKey()+"はtypoか何かだと思う",0);
		}
	}

	static HashMap readStream(Reader a_in,String fname) throws IOException{
		base.MyStreamTokenizer in = new base.MyStreamTokenizer(a_in,fname,false);

		HashMap result = new HashMap();
		boolean hasError=false;
		for(;;){
			try{
				in.skipToStartOfStatement();
				// ストリーム終端
				if(in.ttype==in.TT_EOF) break;

				// 種類を読む
				String type    =in.readWord("ColorFontかBGInfoかTextStyle");
				if(type.equals("ColorFont")){
					String keyname =in.readWordOrQuote("ColorFontの次のキー名");
					FontInfoClickable fi=new FontInfoClickable(keyname);
					fi.color=new Color4();
					fi.color.fg = readColor(in.readQuote("文字色"));
					fi.color.bg = readColor(in.readQuote("背景色"));
					fi.color.fg2= readColor(in.readQuote("選択時文字色"));
					fi.color.bg2= readColor(in.readQuote("選択時背景色"));
					fi.font_size= (int)in.readNumber("フォントサイズ");
					fi.font_name=in.readQuote("フォント名");
					readStyleOption(fi,in);
					result.put(keyname,fi);
					continue;
				}
				if(type.equals("BGInfo")){
					String keyname =in.readWordOrQuote("BGInfoの次のキー名");
					Color bg = readColor(in.readQuote("背景色"));
					String bgfile = in.readQuote("背景画像");
					javax.swing.ImageIcon i=null;
					if(bgfile!=null && bgfile.length()!=0 && !bgfile.equals("-") ){
						i = base.Util.GetImageIconFromJAR(bgfile);
					}
					result.put(keyname,new BGInfo(bg,i));
					continue;
				}
				if(type.equals("TextStyle")){
					String keyname  =in.readWordOrQuote("TextStyleの次のキー名");
					FontInfoClickable fi=new FontInfoClickable(keyname);
					fi.color=new Color4();
					fi.font_name=in.readQuote("フォント名");
					fi.font_size=(int)in.readNumber("フォントサイズ");
					fi.color.fg = readColor(in.readQuote("文字色"));
					fi.color.bg = readColor(in.readQuote("背景色"));
					fi.color.fg2= readColor(in.readQuote("選択時文字色"));
					fi.color.bg2= readColor(in.readQuote("選択時背景色"));
					readStyleOption(fi,in);
					result.put(keyname,fi);
					continue;
				}
				throw in.nomatch("種類"+type+"はColorFontでもBGInfoでもTextStyleでもない");
			}catch(java.text.ParseException e){
				hasError=true;
				App.Log(in.fname+" "+in.lineno()+"行: "+e.getMessage() );
				// 行末または;まで読み飛ばす
				in.skipToEndOfStatement();
			}
		}
		return hasError? null:result;
	}
	public boolean load(String fname){
		try{
			InputStreamReader in = new InputStreamReader(base.Util.OpenFile(fname),"UTF-8");
			try{
				HashMap a =readStream(in,fname);
				if(a!=null){
					config =a;
					App.Log(fname+"を読み終わりました");
					super.clear();
					return true;
				}
			}finally{ in.close(); }
		}
		catch(FileNotFoundException e){ App.Log(e.getMessage());}
		catch(IOException e){ App.Log(fname +":"+e.getMessage()); }
		return false;
	}


}
