package bluntirc;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;

public class WindowPos{
	////////////////////////////////////////////////////////
	//ウィンドウを中央に配置する
	public static void setWindowsPosToCenter(java.awt.Frame window){
	    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	    Dimension frameSize = window.getSize();
	    int x = (frameSize.width >screenSize.width )?0 :((screenSize.width  - frameSize.width )/2);
	    int y = (frameSize.height>screenSize.height)?0:((screenSize.height - frameSize.height)/2);
		window.setLocation(x,y);
	}

	// プロパティからウィンドウの位置と表示状態を設定する
	public static void loadWindowPos(java.awt.Frame window,String name){
		Object o= App.root_property.get(name);
		if( !(o instanceof LinkedList) ) return;
		LinkedList list = ((LinkedList)o);
		if(list.size() <6 ) return;
		int state = ((list.size() >=6 )?PropertyManager.IntValue(list.get(5)):Frame.NORMAL);
		// 最大化されている場合はウィンドウ位置の情報は無視する
		if(0==(state &Frame.MAXIMIZED_BOTH)){
			Rectangle la_rect = new Rectangle();
			la_rect.y      = PropertyManager.IntValue(list.get(0));
			la_rect.x      = PropertyManager.IntValue(list.get(1));
			la_rect.width  = PropertyManager.IntValue(list.get(2));
			la_rect.height = PropertyManager.IntValue(list.get(3));
			window.setBounds(la_rect);
		}
		if(list.size() >=5 ) if( PropertyManager.BooleanValue(list.get(4)) ) window.show();
		 window.setExtendedState(state);
	}
	public static void saveWindowPos(java.awt.Frame window,String name){
		LinkedList list = new LinkedList();
		Rectangle r= window.getBounds();
		list.add(""+ r.y     );
		list.add(""+ r.x     );
		list.add(""+ r.width );
		list.add(""+ r.height);
		list.add(""+ window.isShowing());
		list.add(""+ window.getExtendedState());
		App.root_property.set(name,list);
	}
	public static void saveSplitterPos(String key,JSplitPane c){
		 App.root_property.setInt(key,c.getDividerLocation());
	}
	public static void loadSplitterPos(String key,JSplitPane c){
		Object o= App.root_property.get(key);
		if(o instanceof String){
			try{
				c.setDividerLocation( App.root_property.IntValue(o) );
			}catch(Throwable e){
				App.Log("loadSplitterPos fail"+key +"="+o);
				c.setDividerLocation( -1 );
			}
		}
	}

	////////////////////////////////////////////////////////
	// テーブルの区切り位置をプロパティから読む
	public static void loadTableColPos(JTable table,String prop_name){
		PropertyManager property = App.root_property;
		java.util.List list=property.getList(prop_name);
		int[] w= getColWidthAll(table);
		if(list.size()==w.length){
			for(int i=0;i<w.length;++i){
				w[i] = PropertyManager.IntValue( list.get(i));
			}
			setColWidthAll(table,w);
		}
	}
	public static void saveTableColPos(JTable table,String prop_name){
		PropertyManager property = App.root_property;
		int[] s= getColWidthAll(table);
		LinkedList list = new LinkedList();
		for(int i=0;i<s.length;++i){ list.add(""+s[i]);}
		property.set(prop_name,list);
	}
	public static int[] getColWidthAll(JTable table){
		TableColumnModel tcm=table.getColumnModel() ;
		int size = tcm.getColumnCount();
		int[] result = new int[size*2];
		for(int i = 0; i < size; i++ ){
			TableColumn c = tcm.getColumn(i);
			result[i]      = c.getWidth();
			result[i+size] = c.getModelIndex();
		}
		return result;
	}
	public static void setColWidthAll(JTable table,int[] w){
		TableColumnModel tcm=table.getColumnModel();
		int size = tcm.getColumnCount();
		// まず並べ替える
		for(int i=0;i<size;++i){
			if(size+i>=w.length) break;
			// iは表示順序で、w[size+i]はそこに収まるモデル番号
			table.moveColumn( table.convertColumnIndexToView(w[size+i]),i);
		}
		// 次に幅を設定する
		for(int i=0;i<size;++i){
			if(i>=w.length) break;
			// iは表示順序で、w[i]はその桁の幅
			int width =w[i];
			if(width<=0) width = 16;
			tcm.getColumn(i).setPreferredWidth(width);
		}
	}
}
