// UTF-8 ☀☁☂☃
package bluntirc.djava;
import irc.*;
import base.*;
import bluntirc.*;

import java.util.*;
//import java.io.*;
import java.awt.*;
import java.awt.event.*;
//import java.beans.*;
import javax.swing.*;
import javax.swing.event.*;


class ActionOwner{ Action action; Object owner; }
class ActionCallStack{
	Action action; Object parameter;
	public ActionCallStack(Action a,Object p){ action=a;parameter=p;}
}

public class ActionManager{
	////////////////////////////////
	// アクションと名前の一覧
	public Map actions=new HashMap();
	public void add(Object owner,String name,Action a){
		if(owner==null||name==null || a==null) throw new NullPointerException();
		// 競合する名前があった場合に警告
		if(null!=actions.get(name)){
			App.Log(name+"は既に登録されています");
			return;
		}
		ActionOwner ao = new ActionOwner();
		ao.owner=owner;
		ao.action=a;
		actions.put(name,ao);
	}
	public Action find(String name){
		ActionOwner ao = (ActionOwner)actions.get(name);
		return ao==null?null:ao.action;
	}
	// ownerを指定して一括削除
	public void remove(Object owner){
		for(Iterator it=actions.entrySet().iterator();it.hasNext();){
			Map.Entry me = (Map.Entry)it.next();
			Object value = me.getValue();
			if(((ActionOwner)value).owner==owner ) it.remove();
		}
	}

	/////////////////////////////////
	// アクションの実行

	// コールスタック
	public LinkedList call_stack=new LinkedList();
	public Object call(Action a,Object param){
		if(!a.isEnabled()) return null;
		call_stack.addFirst(new ActionCallStack(a,param));
		try{
			a.actionPerformed(new ActionEvent(App.getApp(),0,""));
		}catch(Throwable e){
			boolean found=false;
			for(Iterator it=App.action_manager.actions.values().iterator();it.hasNext();){
				ActionOwner ao = (ActionOwner)it.next();
				if(ao.action == a && (ao.owner instanceof ScriptItem) ){
					found=true;
					App.hook_manager.parseScriptError(((ScriptItem)ao.owner).getName(),e);
					break;
				}
			}
			if(!found) App.Log(e+" "+e.getMessage());
		}
		return ((ActionCallStack)call_stack.removeFirst()).parameter;
	}
	public Object getStackParameter(){
		if(0==call_stack.size()) return null;
		return ((ActionCallStack)call_stack.getFirst()).parameter;
	}
	public void setStackParameter(Object o){
		if(0==call_stack.size()) return;
		((ActionCallStack)call_stack.getFirst()).parameter = o;
	}

	//////////////////////////////////////////////////////////
	//ユーザが入力したコマンドがアクションなら実行する
	public boolean fireUserCommand(String cmd){
		int first=0;while( first<cmd.length() && " \t".indexOf(cmd.charAt(first))==-1)  ++first;
		int minus = cmd.indexOf('-');
		if(minus<0 || minus >=first) return false;
		String action_name = cmd.substring(0,first);
		Action a = find(action_name);
		if(a==null){
			App.Log("アクション"+action_name+"が見つかりません");
			return true;
		}
		call(a,cmd.substring(first));
		return true;
	}
}
