// UTF-8 ☀☁☂☃
package bluntirc.djava;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import koala.dynamicjava.interpreter.*;
import koala.dynamicjava.parser.wrapper.*;
import java.text.ParseException;

import bluntirc.*;

class ScriptItemDJAVA 
implements ScriptItem // Comparable,
{
	public Object getPlugin(){ return plugin;}
	// Comparable 
	static int id_base=0;
	int id = ++id_base;
	public int compareTo(Object o){ return this.id - ((ScriptItemDJAVA)o).id; }

	// スクリプトごとに変数などの処理系を用意する
	TreeInterpreter interpreter;
	boolean isEnabled(){ return interpreter != null; }
	Object plugin;

	// スクリプトの実行前から用意しておく情報
	File   ScriptFile;
	String ScriptEncoding="UTF-8";
	String ActionPrefix;
	
	public ScriptItemDJAVA(File file){ ScriptFile = file; init();}
	public ScriptItemDJAVA(File file,String enc){ ScriptFile = file;ScriptEncoding=enc; init(); }
	public String getName(){ return ScriptFile.getName();}
	public String getActionName(){return ActionPrefix;}
	public File getFile(){ return ScriptFile;}

	void init(){
		// アクションに使われる名前を決める
		String name = ScriptFile.getName();
		int i=0;
		while(i<name.length()){
			char c = name.charAt(i);
			if( (c>='a' && c<='z')
			||  (c>='A' && c<='Z')
			||  (c>='0' && c<='9')
			||  -1!="-_".indexOf(c)
			){
				++i;
				continue;
			}
			break;
		}
		ActionPrefix =name.substring(0,i);
	}

	boolean load(ScriptManagerWindow manager){
		if(isEnabled()) return false;
		App.Log("loading "+ScriptFile.getName() +" "+ScriptEncoding);
		try{
			TreeInterpreter ix = new TreeInterpreter(new JavaCCParserFactory());
			Reader r= new base.EscapeReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(ScriptFile)),ScriptEncoding));
			boolean result = manager.callScript(this,ix,r,ScriptFile.getName());
			r.close();
			if(result){
				ix.defineVariable("manager",manager);
				r= new StringReader("plugin=new Plugin(manager);");
				result = manager.callScript(this,ix,r,ScriptFile.getName());
				if(result){
					plugin = manager.callResult;
					if(plugin==null){
						App.Log(getName()+" plugin変数がnullです");
						return false;
					}
					App.hook_manager.add(this);
					interpreter =ix;
					return true;
				}
			}
			return result;
		}catch( Throwable e ){
			App.Log("load failed: "+getName()+" "+e.getMessage());
		}
		return false;
    }
	void unload(ScriptManagerWindow manager){
		if(!isEnabled()) return;
		App.Log("unload "+ScriptFile.getName());
		// フックの削除
		App.hook_manager.remove(this);
		// アクションの削除
		App.action_manager.remove(this);
		// unload の実行
		try{
			Reader r= new StringReader("plugin.unload();");
			boolean result = manager.callScript(this,interpreter,r,ScriptFile.getName());
		}catch( Throwable e ){
			App.Log(
				"error in unload script"+getName()
				+":\n exception="+e.toString()
				+":\n message="+e.getMessage()
			);
		}
		interpreter=null;
	}
}

abstract class ActionE extends AbstractAction {
	ActionE(String s){super(s);}
	public abstract void checkEnabled(ScriptItemDJAVA si);
}

// スクリプト管理ダイアログ
public class ScriptManagerWindow 
extends JFrame
implements ScriptManager
{
	// DynamicJavaはクラスのロードに時間がかかるので
	// 事前にどうでもいいスクリプトを実行してロードしておく
	public static void loadDummyScript(){
		try{
			TreeInterpreter ti = new TreeInterpreter(new JavaCCParserFactory());
			Reader r= new StringReader("bluntirc.App.logger.fine(greeting);");
			ti.defineVariable("greeting","DynamicJava embedded.");
			ti.setAccessible(true);
			ti.interpret(r,"loadDummyScript");
		}catch( Throwable e ){
			App.logger.log(java.util.logging.Level.SEVERE,"loadDummyScript",e);
		}
	}

	// スクリプトの実行
	public Object callResult;
	public boolean callScript(ScriptItemDJAVA si,TreeInterpreter ti,Reader r,String filename){
		try{
			// addScriptActionで参照できるように、評価中の ScriptItemDJAVAを覚える
			si_default=si;
			ti.setAccessible(true);
			callResult = ti.interpret(r,filename);
			return true;
		}catch( Throwable e ){
			App.hook_manager.parseScriptError(si.getName(),e);
		}finally{
			si_default=null;
		}
		return false;
	}
	/////////////////////////////////////////////////
	// スクリプトから呼ばれる
	ScriptItemDJAVA si_default;
	public void addScriptAction(String key,Action a){
		if(key==null || a==null) return;
		App.action_manager.add(si_default
			,si_default.getActionName()+"-"+key
			,a
		);
	}


	/////////////////////////////////////////////////

	public ScriptManagerWindow(){
		super("スクリプトの一覧");
		setIconImage( App.icon_app.getImage() );
		list.setFont(new Font("ＭＳ ゴシック",Font.PLAIN,16));

		list.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e){
				updateButtons();
			}
		});

		Box buttons_panel =  Box.createHorizontalBox();
		for(int i=0;i<buttons.length;++i){
			buttons_panel.add(Box.createRigidArea(new Dimension(3,3)) );
			JButton jb = new JButton(buttons[i]);
			jb.setFont(new Font("SansSerif",Font.PLAIN,12));
			jb.setMargin(new Insets(0,2,0,2));
			buttons_panel.add(jb);
		}
		buttons_panel.add(Box.createHorizontalGlue() );
		updateButtons();

		Container all_panel =getContentPane();
		all_panel.add(list,BorderLayout.CENTER);
		all_panel.add(buttons_panel,BorderLayout.SOUTH);

		pack();

	}

	public void exit(){
		for(int i=0;i<list.getItemCount();++i){
			ScriptItemDJAVA si = (ScriptItemDJAVA)scripts.get(i);
			try{
				si.unload(this);
			}catch(Throwable e){ App.logger.log(java.util.logging.Level.SEVERE,"cant unload",e); }
		}
	}

	private java.awt.List list = new java.awt.List();
	private LinkedList scripts = new LinkedList();

	public Component getDialogParent(){ return this; }

	public ScriptItemDJAVA addScript(File file){
		ScriptItemDJAVA si = new ScriptItemDJAVA(file);
		list.add( "無効 "+si.getName() );
		scripts.addLast( si );
		list.select( list.getItemCount()-1);
		updateButtons();
		return si;
	}
	public void removeScript(int index){
		ScriptItemDJAVA si = (ScriptItemDJAVA)scripts.get(index);
		if(si.isEnabled()) si.unload(this);
		list.remove(index);
		scripts.remove(index);
		updateButtons();
	}
	// 開始または再実行
	void startScript(int index){
		ScriptItemDJAVA si = (ScriptItemDJAVA)scripts.get(index);
		if(si.isEnabled()) si.unload(this);
		si.load(this);
		list.replaceItem(
			(si.isEnabled()?"有効":"無効")+ " "+si.getName()
			,index
		);
		list.select(index);
		updateButtons();
	}
	void stopScript(int index){
		ScriptItemDJAVA si = (ScriptItemDJAVA)scripts.get(index);
		si.unload(this);
		list.replaceItem(
			(si.isEnabled()?"有効":"無効")+ " "+si.getName()
			,index
		);
		list.select(index);
		updateButtons();
	}
	// ボタンの有効無効の更新
	void updateButtons(){
		int i= list.getSelectedIndex();
		ScriptItemDJAVA si = i==-1?null:(ScriptItemDJAVA)scripts.get(i);
		for(i=0;i<buttons.length;++i){
			buttons[i].checkEnabled(si);
		}
	}

	File lastCWD=new File("scripts");

	// ボタン類
	ActionE[] buttons = new ActionE[]{
		new ActionE("追加"){
			public void actionPerformed(ActionEvent e){
				JFileChooser fc = new JFileChooser();
				fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
				fc.setMultiSelectionEnabled(true);
				fc.setCurrentDirectory(lastCWD);
				fc.setDialogTitle("open scripts");
				fc.setFileFilter(new javax.swing.filechooser.FileFilter(){
					public String getDescription(){ return "DynamicJava Script";}
					public boolean accept(File f){
						if(!f.canRead()) return false;
						String name = f.getName();
						int dot = name.lastIndexOf('.');
						if(dot==-1) return true;
						String ext = name.substring(dot+1);
						return ext.equals("djava") || ext.equals("java");
					}
				});
				int returnVal = fc.showOpenDialog(getDialogParent());
				if(returnVal == JFileChooser.APPROVE_OPTION) {
					File[] files = fc.getSelectedFiles();
					for(int i=0;i<files.length;++i) addScript(files[i]);
				}
				lastCWD=fc.getCurrentDirectory();
			}
			public void checkEnabled(ScriptItemDJAVA si){
				setEnabled(true);
			}
		},
		new ActionE("開始/更新"){
			public void actionPerformed(ActionEvent e){
				int i= list.getSelectedIndex();
				if(i==-1) return;
				startScript(i);
			}
			public void checkEnabled(ScriptItemDJAVA si){ setEnabled(si!=null); }
		},
		new ActionE("action(test)"){
			public void checkEnabled(ScriptItemDJAVA si){ setEnabled(si!=null && si.isEnabled()); }
			public void actionPerformed(ActionEvent e){
				int i= list.getSelectedIndex();
				if(i==-1) return;
				ScriptItemDJAVA si = (ScriptItemDJAVA)scripts.get(i);
				String action_name = si.getActionName()+"-test";
				Action a = App.action_manager.find(action_name);
				if(a==null){
					App.Log("アクション"+action_name+"が見つかりません");
				}else{
					App.action_manager.call(a,null);
				}
			}
		},
		new ActionE("停止"){
			public void checkEnabled(ScriptItemDJAVA si){ setEnabled(si!=null && si.isEnabled()); }
			public void actionPerformed(ActionEvent e){
				int i= list.getSelectedIndex();
				if(i==-1) return;
				stopScript(i);
			}
		},
		new ActionE("エディタ"){
			public void checkEnabled(ScriptItemDJAVA si){ setEnabled(si!=null); }
			public void actionPerformed(ActionEvent e){
				int i= list.getSelectedIndex();
				if(i==-1) return;
				ScriptItemDJAVA si = (ScriptItemDJAVA)scripts.get(i);
				App.os_dependence.editTextFile(si.getFile() );
			}
		},

		new ActionE("削除"){
			public void actionPerformed(ActionEvent e){
				int i= list.getSelectedIndex();
				if(i==-1) return;
				removeScript(i);
			}
			public void checkEnabled(ScriptItemDJAVA si){ setEnabled(si!=null); }
		},
		new ActionE("閉じる"){
			public void actionPerformed(ActionEvent e){
				hide();
			}
			public void checkEnabled(ScriptItemDJAVA si){ setEnabled(si!=null); }
		},
	};
	public LinkedList getScriptInfo(){
		LinkedList s = new LinkedList();
		int i=0;
		for(Iterator it=scripts.iterator();it.hasNext();){
			ScriptItemDJAVA si = (ScriptItemDJAVA)it.next();
			s.add( (si.isEnabled()?"1":"0")+si.ScriptFile.getPath() );
		}
		return s;
	}
	public void loadInfo(String s){
		ScriptItemDJAVA si = addScript(new File( s.substring(1)));
		if(s.charAt(0)=='1') startScript(list.getItemCount()-1);
	}
}
