package buffer;
import java.util.*;

public class PackedLineBlock{
	// 行数
	int line_used=0;
		public int getLineCount(){return line_used;}

	// 行に含まれる文字を行数分まとめた配列
	char [] bulk_text;
		public char[] getTextArray(){ return bulk_text;}

	// 行に含まれるスタイルを行数分まとめた配列
	byte[] bulk_style;
		public byte[] getStyleArray(){ return bulk_style;}

	// 行ごとにデータの開始位置を記録する
	int[] text_start  =new int[maxline+1];
		public int getTextStart(int line){ return text_start[line  ];}
		public int getTextEnd  (int line){ return text_start[line+1];}
	int[] style_start =new int[maxline+1];
		public int getStyleStart(int line){ return style_start[line  ];}
		public int getStyleEnd  (int line){ return style_start[line+1];}

	// 統計を取る
	static final int maxline=200; // 最大行数
	static int total_line_used  = 100; // 初期値はでたらめかも
	static int total_text_used  =8200;
	static int total_style_used =1200;

	// ブロックを作成する
	// tl,scには最低限必要なサイズが入っている
	public PackedLineBlock(int tl,int sc){
		double k = 1.2/total_line_used;
		bulk_text     = new char[tl+(int)(k*total_text_used *(maxline-1))];
		bulk_style    = new byte[sc+(int)(k*total_style_used*(maxline-1))];
		text_start[0]=0;
		style_start[0]=0;
	}

	static char[] reallocCharArray(char[] old,int new_length,int copy_length){
		char[] neo=new char[new_length];
		for(int i=0;i<copy_length;++i) neo[i]=old[i];
		return neo;
	}
	static byte[] reallocByteArray(byte[] old,int new_length,int copy_length){
		byte[] neo=new byte[new_length];
		for(int i=0;i<copy_length;++i) neo[i]=old[i];
		return neo;
	}

	/////////////////////////////////////////////////////////
	// 行を追加できるか

	int text_realloc_count =0;
	int style_realloc_count=0;
	public boolean canAppendLine(int text_length,int style_length){
		boolean result=(  line_used    < maxline);
		if(result){
			int old_used;
			double k = ((line_used+1)*(0.25/maxline)+1.2)/total_line_used;

			old_used = text_start[line_used];
			if( bulk_text.length < old_used+text_length){
				++text_realloc_count;
				int new_length = old_used+text_length +(maxline-line_used-1)*(int)(total_text_used*k);
/*
				System.err.println("realloc text: count="+text_realloc_count
				+" append="+(new_length-bulk_text.length)
				+" copy="+old_used
				);
*/
				bulk_text=reallocCharArray(bulk_text,new_length,old_used);
			}

			old_used = style_start[line_used];
			if(bulk_style.length <old_used+style_length){
				++style_realloc_count;
				int new_length = old_used+style_length +(maxline-line_used-1)*(int)(total_style_used*k);
/*
				System.err.println("realloc style: count="+style_realloc_count
				+" append="+(new_length-bulk_style.length)
				+" copy="+old_used
				 );
*/
				bulk_style=reallocByteArray(bulk_style,new_length,old_used);
			}
		}
		if(!result) close_block();
		return result;
	}
	// 行にデータを追加する
	public int appendLine( char[] text,byte[] style ){
		++total_line_used;
		total_text_used+=text.length;
		total_style_used+=style.length;

		int i,p;
		p =text_start[line_used];
		for(i=0;i<text.length;++i) bulk_text[p++]=text[i];
		text_start[line_used+1] = p;

		p =style_start[line_used];
		for(i=0;i<style.length;++i) bulk_style[p++]=style[i];
		style_start[line_used+1] = p;

		return line_used++;
	}

	// ブロックを閉じる
	int close_block(){
		// 不要なメモリを捨てる
		int used;
		if(	bulk_text.length >(used=text_start[line_used]))
			bulk_text=reallocCharArray(bulk_text,used,used);
		if(	bulk_style.length >(used=style_start[line_used]))
			bulk_style=reallocByteArray(bulk_style,used,used);

		int blocksize = 4+60; // 参照 + sizeof this(てきとう)
		blocksize += text_start .length*4 +12;
		blocksize += style_start.length*4 +12;
		int per_line = blocksize / line_used;

		// 無駄なメモリは
/*
		System.err.println("TextBlock stats:"
		+"\n  text  : /line="+(text_start [line_used])/line_used
		+" realloc_count="+text_realloc_count
		+"\n  style : /line="+(style_start [line_used])/line_used
		+" realloc_count="+style_realloc_count
		+"\n  total: text/lines="+(total_text_used/total_line_used)
		+" style/lines="+(total_style_used/total_line_used)
		);
*/		return per_line;
	}
}
