// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.PropertyChangeListener;
import java.io.File;
// SwingPropertyChangeSupport
/*
import java.util.*;
*/

public abstract class DialogEditItem_Button 
extends DialogEditItem
implements javax.swing.Action
{
	//////////////////////////////
	// AbstractAction からのコピー
    protected SwingPropertyChangeSupport changeSupport;
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if( changeSupport == null 
        ||	(oldValue != null && newValue != null && oldValue.equals(newValue)) 
        ) return;
		changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
	public  void addPropertyChangeListener(PropertyChangeListener listener) {
		if( changeSupport == null ) changeSupport = new SwingPropertyChangeSupport(this);
		changeSupport.addPropertyChangeListener(listener);
	}
	public  void removePropertyChangeListener(PropertyChangeListener listener) {
		if( changeSupport == null ) return;
		changeSupport.removePropertyChangeListener(listener);
	}
    public  PropertyChangeListener[] getPropertyChangeListeners(){
        if( changeSupport == null ) return new PropertyChangeListener[0];
        return changeSupport.getPropertyChangeListeners();
    }
	//////////////////////////////
    protected boolean enabled = true;
    public boolean isEnabled(){ return enabled; }
    public void setEnabled(boolean newValue){
		boolean oldValue = this.enabled;
		if( oldValue != newValue ){
			this.enabled = newValue;
			firePropertyChange("enabled",new Boolean(oldValue), new Boolean(newValue));
		}
	}
	//////////////////////////////
	private java.util.Map arrayTable;
	public void putValue(String key, Object newValue){
		if( arrayTable == null ) arrayTable =new java.util.HashMap();
		Object oldValue = null;
		if( arrayTable.containsKey(key) ) oldValue = arrayTable.get(key);
		if( newValue == null ){
			arrayTable.remove(key);
		}else{
			arrayTable.put(key,newValue);
		}
		firePropertyChange(key, oldValue, newValue);
    }
	public Object getValue(String key){
		if(key.equals(Action.NAME)) return getCaption();
		if(key.equals(Action.SHORT_DESCRIPTION)) return getShortDesc();
		if(key.equals(Action.LONG_DESCRIPTION)) return getDesc();
		return arrayTable==null?null:arrayTable.get(key);
	}
	///////////////////////

	abstract public String getCaption();
	public String getShortDesc(){ return "";}
	public String getDesc(){ return "";}
	public void applyValue(ConnTreeNode node ,Component c){}
	public Component createControl(ConnTreeNode node){ return new JButton(this); }

	public void layout(Component item,GridBagLayout gbl,GridBagConstraints c,Container panel,Object listener ){
		((JButton)item).setFont(textFont);

	// ボタンのアクションが実行される前に呼ばれてしまうので意味ない
	// 	((JButton)item).addActionListener( (ActionListener)listener );

		JTextArea l = new JTextArea( getShortDesc() );
		l.setFont(textFont);
		l.setEditable(false);
		l.setForeground(SystemColor.controlText);
		l.setBackground(SystemColor.control);

		JTextArea jta = new JTextArea(getDesc());
		jta.setFont(textFont);
		jta.setEditable(false);
		jta.setForeground(SystemColor.controlText);
		jta.setBackground(SystemColor.control);

		c.weightx = 0.0;c.weighty = 0.0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = 1;

		c.anchor = GridBagConstraints.EAST;
		gbl.setConstraints(l, c); panel.add(l);
		c.anchor = GridBagConstraints.WEST ;

		c.fill =  GridBagConstraints.NONE;
		c.gridwidth = 2;
		gbl.setConstraints(item, c); panel.add(item);
		c.gridwidth = 1;
		c.fill =  GridBagConstraints.NONE;

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gbl.setConstraints(jta, c); panel.add(jta);
	}
}
