// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.PropertyChangeListener;
import java.io.File;
// SwingPropertyChangeSupport
/*
import java.util.*;
*/

public abstract class DialogEditItem_FilePath extends DialogEditItem{
	public abstract String getPropertyKey();
	public String getDefaultValue(){ return "";}
	public boolean isEditable(){return true;}
	public int getFileSelectionMode(){ return JFileChooser.FILES_ONLY ;}

	public void applyValue(ConnTreeNode node ,Component c){
		node.property.set( getPropertyKey(),((JTextField)c).getText());
	}
	public JTextField tf;
	public ActionListener dialog_listener;


	public Component createControl(ConnTreeNode node){
		JTextField c = tf = new JTextField();
		if(node==null){
			c.setText( getDefaultValue());
		}else{
			c.setText( node.property.setDefaultString(getPropertyKey(),getDefaultValue()));
		}
		c.setEditable(isEditable());
		return c;
	}

	public static String getPath(String quoted){
		if(quoted==null) return null;
		String[] cmdarray = App.os_dependence.parsecmd(null,quoted,"");
		if(cmdarray!=null && cmdarray.length >0) return cmdarray[0];
		return null;
	}

	public void layout(Component item,GridBagLayout gbl,GridBagConstraints c,Container panel,Object listener  ){
		dialog_listener=(ActionListener)listener;
		JButton button = new JButton(new AbstractAction("..."){
			public void actionPerformed(java.awt.event.ActionEvent e){
				JFileChooser chooser = new JFileChooser();
				chooser.setFont(textFont);
				// CWDを設定
				chooser.setCurrentDirectory( (new File("nonexistent")).getAbsoluteFile().getParentFile() );
				
				// 選択モード
				chooser.setFileSelectionMode( getFileSelectionMode());
				
				// 以前の値を設定
				String s = tf.getText();
				String[] cmdarray =null;
				if(s!=null){
					cmdarray = App.os_dependence.parsecmd(null,s,"");
					if(cmdarray!=null && cmdarray.length >0) chooser.setSelectedFile(new File(cmdarray[0]));
				}
				int returnVal = chooser.showOpenDialog(tf);
			    if(returnVal == JFileChooser.APPROVE_OPTION){
					if( cmdarray!=null && cmdarray.length >1){
						cmdarray[0]=chooser.getSelectedFile().getPath();
						StringBuffer sb = new StringBuffer();
						for(int i=0;i<cmdarray.length;++i){
							if(cmdarray[i]==null) continue;
							sb.append(Util.qq(cmdarray[i]));
							sb.append(' ');
						}
						tf.setText( sb.toString() );
					}else{
						tf.setText( Util.qq(chooser.getSelectedFile().getPath()) );
					}
					dialog_listener.actionPerformed(e);
			    }
			}
		});
		button.setMargin(new Insets(0,0,0,0));

		((JTextField)item).setFont(textFont);
		((JTextField)item).addKeyListener( (KeyListener)listener );
		Dimension d = item.getPreferredSize() ;
		d.width=150;
		((JTextField)item).setMinimumSize(d);
		((JTextField)item).setPreferredSize(d);

		JTextArea l = new JTextArea( getCaption() );
		l.setFont(textFont);
		l.setEditable(false);
		l.setForeground(SystemColor.controlText);
		l.setBackground(SystemColor.control);

		JTextArea jta = new JTextArea(getDesc());
		jta.setFont(textFont);
		jta.setEditable(false);
		jta.setForeground(SystemColor.controlText);
		jta.setBackground(SystemColor.control);

		c.weightx = 0.0;c.weighty = 0.0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = 1;

		c.anchor = GridBagConstraints.EAST;
		gbl.setConstraints(l, c); panel.add(l);
		c.anchor = GridBagConstraints.WEST ;

		c.fill =  GridBagConstraints.HORIZONTAL;
		gbl.setConstraints(item, c); panel.add(item);
		c.fill =  GridBagConstraints.NONE;

		gbl.setConstraints(button, c); panel.add(button);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gbl.setConstraints(jta, c); panel.add(jta);
	}
}
