// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.PropertyChangeListener;
import java.io.File;
// SwingPropertyChangeSupport
/*
import java.util.*;
*/

public abstract class DialogEditItem_TextArea extends DialogEditItem{
	abstract public String getCaption();
	abstract public String getPropertyKey();
	public String getDefaultValue(){ return "";}
	public boolean isEditable(){return true;}

	public void applyValue(ConnTreeNode node ,Component c){
		node.property.set( getPropertyKey(),((JTextArea)c).getText());
	}
	public Component createControl(ConnTreeNode node){
		JTextArea c = new JTextArea();
		if(node==null){
			c.setText( getDefaultValue());
		}else{
			c.setText( node.property.setDefaultString(getPropertyKey(),getDefaultValue()));
		}
		c.setEditable(isEditable());
		return c;
	}
	public void layout(Component item,GridBagLayout gbl,GridBagConstraints c,Container panel,Object listener  ){
		((JTextArea)item).setFont(textFont);
		((JTextArea)item).addKeyListener( (KeyListener)listener );
		Dimension d = item.getPreferredSize() ;
		d.width=(d.width>130?d.width:130)+20;
		d.height= d.width/2;

		JTextArea l = new JTextArea( getCaption() );
		l.setFont(textFont);
		l.setEditable(false);
		l.setForeground(SystemColor.controlText);
		l.setBackground(SystemColor.control);

		JTextArea jta = new JTextArea(getDesc());
		jta.setFont(textFont);
		jta.setEditable(false);
		jta.setForeground(SystemColor.controlText);
		jta.setBackground(SystemColor.control);

		JScrollPane scroll = new JScrollPane(item);
		scroll.setMinimumSize(d);
		scroll.setPreferredSize(d);

		c.weightx = 0.0;c.weighty = 0.0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = 1;

		c.anchor = GridBagConstraints.EAST;
		gbl.setConstraints(l, c); panel.add(l);
		c.anchor = GridBagConstraints.WEST ;

		c.fill =  GridBagConstraints.HORIZONTAL;
		c.gridwidth = 2;
		gbl.setConstraints(scroll, c); panel.add(scroll);
		c.gridwidth = 1;
		c.fill =  GridBagConstraints.NONE;

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gbl.setConstraints(jta, c); panel.add(jta);
	}
}
