package gui;
import java.awt.*;
import java.awt.event.*;

import java.beans.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.BasicArrowButton;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Color;

import javax.swing.*;


public class MyScrollBarUI
extends javax.swing.plaf.basic.BasicScrollBarUI
{
	protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds){
		if(incrButton!=null) incrButton.setOpaque(false);
		if(decrButton!=null) decrButton.setOpaque(false);
		if(trackHighlight == DECREASE_HIGHLIGHT) paintDecreaseHighlight(g);
		if(trackHighlight == INCREASE_HIGHLIGHT) paintIncreaseHighlight(g);
    }
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds){
		if(thumbBounds.isEmpty() || !scrollbar.isEnabled()) return;

		int w = thumbBounds.width;
		int h = thumbBounds.height;		
		g.translate(thumbBounds.x, thumbBounds.y);

		g.setColor(thumbDarkShadowColor);
		g.drawRect(0, 0, w-1, h-1);    

//		g.setColor(thumbColor);
//		g.fillRect(0, 0, w-1, h-1);

		g.setColor(thumbHighlightColor);
		g.drawLine(1, 1, 1, h-2);
		g.drawLine(2, 1, w-3, 1);

		g.setColor(thumbLightShadowColor);
		g.drawLine(2, h-2, w-2, h-2);
		g.drawLine(w-2, 1, w-2, h-3);

		g.translate(-thumbBounds.x, -thumbBounds.y);
	}
    protected JButton createDecreaseButton(int orientation)  {
        return new MyBasicArrowButton(orientation, 
				    UIManager.getColor("ScrollBar.thumb"),
				    UIManager.getColor("ScrollBar.thumbShadow"),
				    UIManager.getColor("ScrollBar.thumbDarkShadow"),
				    UIManager.getColor("ScrollBar.thumbHighlight"));
    }
    protected JButton createIncreaseButton(int orientation)  {
        return new MyBasicArrowButton(orientation,
				    UIManager.getColor("ScrollBar.thumb"),
				    UIManager.getColor("ScrollBar.thumbShadow"),
				    UIManager.getColor("ScrollBar.thumbDarkShadow"),
				    UIManager.getColor("ScrollBar.thumbHighlight"));
    }
}

class MyBasicArrowButton 
extends BasicArrowButton{
	protected Color shadow;
	protected Color darkShadow;
	protected Color highlight;

	public MyBasicArrowButton(int direction, Color background, Color shadow,Color darkShadow, Color highlight) {
		super(direction);
		setBackground(background);
		this.shadow = shadow;
		this.darkShadow = darkShadow;
		this.highlight = highlight;
	}

	public void paint(Graphics g) {
	    Color origColor;
	    boolean isPressed, isEnabled;
	    int w, h, size;
		w = getSize().width;
		h = getSize().height;
	    origColor = g.getColor();
	    isPressed = getModel().isPressed();
	    isEnabled = isEnabled();

//		g.setColor(getBackground());
//		g.fillRect(1, 1, w-2, h-2);

            /// Draw the proper Border
            if (isPressed) {
                g.setColor(shadow);
                g.drawRect(0, 0, w-1, h-1);
            } else {
                // Using the background color set above
                g.drawLine(0, 0, 0, h-1);
                g.drawLine(1, 0, w-2, 0);

                g.setColor(highlight);    // inner 3D border
                g.drawLine(1, 1, 1, h-3);
                g.drawLine(2, 1, w-3, 1);

                g.setColor(shadow);       // inner 3D border
                g.drawLine(1, h-2, w-2, h-2);
                g.drawLine(w-2, 1, w-2, h-3);

                g.setColor(darkShadow);     // black drop shadow  __|
                g.drawLine(0, h-1, w-1, h-1);
                g.drawLine(w-1, h-1, w-1, 0);
            }

            // If there's no room to draw arrow, bail
            if(h < 5 || w < 5)      {
                g.setColor(origColor);
                return;
            }

            if (isPressed) {
                g.translate(1, 1);
            }

            // Draw the arrow
            size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
	    paintTriangle(g, (w - size) / 2, (h - size) / 2,
				size, direction, isEnabled);

            // Reset the Graphics back to it's original settings
            if (isPressed) {
                g.translate(-1, -1);
	    }
	    g.setColor(origColor);

        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    
    	public boolean isFocusTraversable() {
	  return false;
	}

	public void paintTriangle(Graphics g, int x, int y, int size, 
					int direction, boolean isEnabled) {
	    Color oldColor = g.getColor();
	    int mid, i, j;

	    j = 0;
            size = Math.max(size, 2);
	    mid = (size / 2) - 1;
	
	    g.translate(x, y);
	    if(isEnabled)
		g.setColor(darkShadow);
	    else
		g.setColor(shadow);

            switch(direction)       {
            case NORTH:
                for(i = 0; i < size; i++)      {
                    g.drawLine(mid-i, i, mid+i, i);
                }
                if(!isEnabled)  {
                    g.setColor(highlight);
                    g.drawLine(mid-i+2, i, mid+i, i);
                }
                break;
            case SOUTH:
                if(!isEnabled)  {
                    g.translate(1, 1);
                    g.setColor(highlight);
                    for(i = size-1; i >= 0; i--)   {
                        g.drawLine(mid-i, j, mid+i, j);
                        j++;
                    }
		    g.translate(-1, -1);
		    g.setColor(shadow);
		}
		
		j = 0;
                for(i = size-1; i >= 0; i--)   {
                    g.drawLine(mid-i, j, mid+i, j);
                    j++;
                }
                break;
            case WEST:
                for(i = 0; i < size; i++)      {
                    g.drawLine(i, mid-i, i, mid+i);
                }
                if(!isEnabled)  {
                    g.setColor(highlight);
                    g.drawLine(i, mid-i+2, i, mid+i);
                }
                break;
            case EAST:
                if(!isEnabled)  {
                    g.translate(1, 1);
                    g.setColor(highlight);
                    for(i = size-1; i >= 0; i--)   {
                        g.drawLine(j, mid-i, j, mid+i);
                        j++;
                    }
		    g.translate(-1, -1);
		    g.setColor(shadow);
                }

		j = 0;
                for(i = size-1; i >= 0; i--)   {
                    g.drawLine(j, mid-i, j, mid+i);
                    j++;
                }
		break;
            }
	    g.translate(-x, -y);	
	    g.setColor(oldColor);
	}
	
}

