// UTF-8 ☀☁☂☃
package irc;
import base.*;
import java.util.*;

public class IRCUser
implements Comparable,IRCChannelNameOrPrefix,Comparator
{
	// コンストラクタ
	private IRCUser(byte[] src){ set(src);}
	public static IRCUser createByIRCConnection(byte[] prefix){ return new IRCUser(prefix); }
	public static IRCUser createComparator(){ return new IRCUser("Comparator".getBytes()); }

	// nicknameとprefix

	protected byte[] NickBytes;
	protected byte[] AfterNickBytes;
		public byte[] getNickBytes(){return NickBytes;}
		public byte[] getAfterNickBytes(){return AfterNickBytes;}

	protected String NickStr;
	protected String AfterNickStr;
	protected String PrefixStr;
		public String getName(){return NickStr;}
		public String getNick(){ return NickStr;}
		public String getAfterNickStr(){ return AfterNickStr;}
		public String getPrefixStr(){ return PrefixStr;}

	// implements IRCChannelNameOrPrefix
	public String getShortName(){ return NickStr;}
	public String getPrintableName(){ return NickStr;}
	public String getEscapedName(){return PrefixStr;}
	public byte[] getRawBytes(){ return NickBytes; }
	// getRawBytesがprefixではなくnickを返すのは主にIRCコマンドの送信用だから

	// ソート用
	public byte[] getUserNameBytes(){
		if(AfterNickBytes!=null){
			int i = Util.ByteIndexOf(AfterNickBytes,'@');
			if(i>0 && i<=AfterNickBytes.length ) return Util.ByteSubString(AfterNickBytes,1,i);
		}
		return new byte[0];
	}
	public byte[] getHostBytes(){
		if(AfterNickBytes!=null){
			int i = Util.ByteIndexOf(AfterNickBytes,'@');
			if(i>0 && i<AfterNickBytes.length ) return Util.ByteSubString(AfterNickBytes,i+1,AfterNickBytes.length);
		}
		return new byte[0];
	}

	public void set(byte[] src){
		int i= Util.ByteIndexOf(src,'!');
		if(i==-1) i=src.length;
		NickStr = Util.fromJIS(NickBytes=Util.ByteSubString(src,0,i));
		AfterNickStr = Util.fromJIS(AfterNickBytes=Util.ByteSubString(src,i,src.length));
		PrefixStr = NickStr+ AfterNickStr;
	}
	public void changeNick(byte[] src){
		int i= Util.ByteIndexOf(src,'!');
		if(i==-1) i=src.length;
		NickStr = Util.fromJIS(NickBytes=Util.ByteSubString(src,0,i));
		PrefixStr = NickStr+ AfterNickStr;
	}

	//////////////////////

	public static final int tolower(int src){
		if(src >= 'A' && src <= 'Z') return src + ((int)'a'-(int)'A');
		int i= "[]\\".indexOf((char)src);
		if(i==-1) return src;
		return "{}|".charAt(i);
	}

	// comparator
	public final int compare(Object o1, Object o2){
		if(o1==o2) return 0;
		if(o1 instanceof IRCChannelMember) o1 = ((IRCChannelMember)o1).getUser();
		if(o2 instanceof IRCChannelMember) o2 = ((IRCChannelMember)o2).getUser();
		if(o1==o2) return 0;
		if(o1 instanceof IRCUser) o1 = ((IRCUser)o1).NickBytes;
		if(o2 instanceof IRCUser) o2 = ((IRCUser)o2).NickBytes;
		if(o1==o2) return 0;
		byte[] a = (byte[]) o1;
		byte[] b = (byte[]) o2;
		if(a==b) return 0;
		int minlength = (a.length<b.length?a.length:b.length);
		for(int i=0;i<minlength;++i){
			int r = tolower((int)a[i])-tolower((int)b[i]);
			if(r!=0) return r;
		}
		return a.length - b.length;
	}

	// comparable
	public final int compareTo (Object b){ return compare(this,b); }
	public final boolean equals(Object b){ return 0==compare(this,b); }

	//////////////////////
	// who reply 
	protected String Server;
	protected int HopCount =-2;
	protected String HomeGone;
	protected String RealName;
		public String getServer  (){return Server  ;}
		public String getHomeGone(){return HomeGone;}
		public int    getHopCount(){return HopCount;}
		public String getRealName(){return RealName;}

	// who reply の内容から情報を補う
	void setWhoReply(byte[] server,int hopcount,String RealName,byte[] baHomeGone){
		Server = base.Util.RecycleString(Util.fromJIS(server));
		this.HopCount=hopcount;
		this.RealName=RealName;
		if(baHomeGone.length !=0 ){
			HomeGone=base.Util.RecycleString(""+ (char)baHomeGone[0]);
		}else{
			HomeGone=null;
		}
	}


	//////////////////////
	// prefixの補充を行う
	public int updatePrefix(byte[] new_AfterNickBytes,int start){
		// 以前のprefixとは違う人ならwho情報をクリアして2を返す
		// 単にprefixを補っただけなら1を返す
		// その必要もなかったなら0

		// 例えば共通するチャンネルが全くないユーザの場合、
		// メッセージがくる度に異なるユーザである可能性がある
		// 共通するチャンネルがある場合はquitの際にハッシュからremoveされるので
		// 調べる必要はないのだが。

		int r=1;
		if( AfterNickBytes.length!=0 ){
			// 変更がないのなら何もしない
			if( 0==Util.compareByteArray(AfterNickBytes,0,new_AfterNickBytes,start) ) return 0;
			// 以前と違うユーザのようなのでwho情報をクリアする
			Server=null;
			RealName=null;
			HopCount=-2;
			HomeGone=null;
			r=2;
		}
		AfterNickStr = Util.fromJIS(AfterNickBytes = Util.ByteSubString(new_AfterNickBytes,start,new_AfterNickBytes.length));
		PrefixStr = NickStr+ AfterNickStr;
		return r;
	}
}
