/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder.value;

import bodybuilder.builder.value.ExtendedValueMapping;

public abstract class ExtendedValue {
    public static boolean isExtended(String value) {
        if (value == null) {
            return false;
        }
        if ((value = value.trim()) == null || value.length() < 4) {
            return false;
        }
        if (!value.startsWith("#{") || !value.endsWith("}")) {
            return false;
        }
        value = ExtendedValue.format(value);
        return ExtendedValueMapping.hasValue(value);
    }

    public static Object getValue(String value) {
        value = value.trim();
        ExtendedValue extVal = ExtendedValueMapping.getExtendedValue(value = ExtendedValue.format(value));
        if (extVal == null) {
            return null;
        }
        return extVal.value(value);
    }

    protected abstract Object value(String var1);

    private static String format(String value) {
        return value.substring(2, value.length() - 1);
    }
}

