/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.inspector.InspectorMapping;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;

public abstract class Inspector {
    private List targets = new ArrayList();

    public List getTargets() {
        return this.targets;
    }

    public void addTarget(String target) {
        this.targets.add(target);
    }

    public abstract void assertEquals(Object var1, Object var2, ObjectBackTrace var3);

    public static void assertObjectEquals(Object expected, Object actual) {
        ObjectBackTrace trace = new ObjectBackTrace();
        Inspector.assertObjectEquals(expected, actual, trace);
        trace.clear();
    }

    public static void assertObjectEquals(Object expected, Object actual, ObjectBackTrace trace) {
        trace.append(actual);
        Inspector.assertNullEquals(expected, actual, trace);
        if (expected == null && actual == null) {
            return;
        }
        Inspector inspector = InspectorMapping.getInspector(expected);
        if (inspector != null) {
            List actualClassNames = ObjectUtils.getClassNames(actual);
            List targets = inspector.getTargets();
            boolean isImplement = false;
            for (int i = 0; i < actualClassNames.size(); ++i) {
                String type = (String)actualClassNames.get(i);
                String pkg = ObjectUtils.getPackage(type, true);
                if (!targets.contains(type) && !targets.contains(pkg)) continue;
                isImplement = true;
                break;
            }
            if (!isImplement) {
                Inspector.rethrow("unimplement class", inspector.getTargets(), actual.getClass().getName(), trace);
            }
            trace.indent();
            inspector.assertEquals(expected, actual, trace);
            trace.unindent();
        } else {
            Inspector.assertClassEquals(expected, actual, trace);
            if (Inspector.isPossibleRegexComparing(expected, actual)) {
                String regex = ((String)expected).trim();
                regex = regex.substring(1, regex.length() - 1);
                Inspector.assertRegexEquals(regex, (String)actual, trace);
            } else {
                if (expected instanceof String) {
                    expected = Inspector.unescapeRegex((String)expected);
                }
                if (!expected.equals(actual)) {
                    Inspector.rethrow(expected, actual, trace);
                }
            }
        }
    }

    protected static void assertNullEquals(Object expected, Object actual, ObjectBackTrace trace) {
        if (expected != null && actual == null || expected == null && actual != null) {
            Inspector.rethrow(expected, actual, trace);
        }
    }

    protected static void assertClassEquals(Object expected, Object actual, ObjectBackTrace trace) {
        if (!Config.isInspectionClass()) {
            return;
        }
        Class<?> expectedClass = expected.getClass();
        Class<?> actualClass = actual.getClass();
        if (!expectedClass.getName().equals(actualClass.getName())) {
            Inspector.rethrow("classes differ", expectedClass, actualClass, trace);
        }
    }

    protected static void assertSizeEquals(int expected, int actual, ObjectBackTrace trace) {
        Inspector.assertSizeEquals("size differ", expected, actual, trace);
    }

    protected static void assertSizeEquals(String message, int expected, int actual, ObjectBackTrace trace) {
        if (!Config.isInspectionSize()) {
            return;
        }
        if (expected != actual) {
            Inspector.rethrow(message, String.valueOf(expected), String.valueOf(actual), trace);
        }
    }

    protected static void assertKeySetEquals(Set expected, Set actual, ObjectBackTrace trace) {
        Inspector.assertKeySetEquals("key set differ", expected, actual, trace);
    }

    protected static void assertKeySetEquals(String message, Set expected, Set actual, ObjectBackTrace trace) {
        Iterator expectedIte = expected.iterator();
        Iterator actualIte = actual.iterator();
        while (expectedIte.hasNext()) {
            Object expectedElement = expectedIte.next();
            if (actual.contains(expectedElement)) continue;
            Inspector.rethrow(message, expectedElement, null, trace);
        }
        if (Config.isInspectionKeySetStrictly()) {
            while (actualIte.hasNext()) {
                Object actualElement = actualIte.next();
                if (expected.contains(actualElement)) continue;
                Inspector.rethrow(message, null, actualElement, trace);
            }
        }
    }

    protected static String unescapeRegex(String str) {
        if (!str.matches("^ *\\\\+/.+/ *$")) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        int idx = buf.indexOf("\\");
        buf.deleteCharAt(idx);
        return buf.toString();
    }

    protected static boolean isPossibleRegexComparing(Object regex, Object actual) {
        if (!Config.isInspectionRegex()) {
            return false;
        }
        if (!(regex instanceof String) || !(actual instanceof String)) {
            return false;
        }
        String regexStr = ((String)regex).trim();
        if (regexStr == null || regexStr.length() < 3) {
            return false;
        }
        return regexStr.startsWith("/") && regexStr.endsWith("/");
    }

    protected static void assertRegexEquals(String regex, String actual, ObjectBackTrace trace) {
        Inspector.assertRegexEquals("not macth regular expression", regex, actual, trace);
    }

    protected static void assertRegexEquals(String message, String regex, String actual, ObjectBackTrace trace) {
        if (regex == null && actual == null) {
            return;
        }
        if (actual == null || regex == null) {
            Inspector.rethrow(message, regex, actual, trace);
        }
        if (!actual.matches(regex)) {
            Inspector.rethrow(message, regex, actual, trace);
        }
    }

    protected static void rethrow(Object expected, Object actual, ObjectBackTrace trace) {
        Inspector.rethrow(null, expected, actual, trace);
    }

    protected static void rethrow(String message, Object expected, Object actual, ObjectBackTrace trace) {
        StringBuffer buffer = new StringBuffer();
        if (message == null) {
            buffer.append("objects differ");
        } else {
            buffer.append(message);
        }
        buffer.append(" ");
        buffer.append("expected:<");
        buffer.append(expected);
        buffer.append("> but was:<");
        buffer.append(actual);
        buffer.append(">");
        buffer.append(System.getProperty("line.separator"));
        buffer.append(trace.dump());
        throw new AssertionFailedError(buffer.toString());
    }
}

