/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.dicon;

import bodybuilder.test.TestCaseXML;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.test.dicon.InjectedObjects;
import bodybuilder.util.jdom.JDOMUtils;
import org.jdom.Element;

public class DIConTestCaseXML
extends TestCaseXML {
    public static final int SETTER_INJECTION = 2;
    public static final int CONSTRUCTOR_INJECTION = 3;
    protected String target = null;
    private int type = 2;
    protected Execute execute = null;
    protected Return ret = null;
    protected Catch catch_ = null;
    protected InjectedObjects injectedObjects = null;
    protected DatabaseSetUp databaseSetUp = null;
    protected InjectedObjects expectedObjects = null;
    protected DatabaseAssertion databaseAssertion = null;

    protected void build() {
        super.build();
        this.loadTarget(this.root);
        Element input = JDOMUtils.getRequiredChild(this.root, "input");
        this.loadInput(input);
        Element expected = JDOMUtils.getRequiredChild(this.root, "expected");
        this.loadExpect(expected);
    }

    protected void loadTarget(Element root) {
        Element target = JDOMUtils.getRequiredChild(root, "target");
        this.target = target.getTextTrim();
        String type = target.getAttributeValue("type");
        this.loadType(type);
    }

    private void loadType(String type) {
        if ("2".equals(type)) {
            this.type = 2;
        } else if ("3".equals(type)) {
            this.type = 3;
        }
    }

    private void loadInput(Element input) {
        Element databaseElem;
        Element execElem = JDOMUtils.getRequiredChild(input, "execute");
        this.execute = new Execute(execElem);
        Element compElem = input.getChild("component");
        if (compElem != null) {
            this.injectedObjects = new InjectedObjects(compElem, this.type);
        }
        if ((databaseElem = input.getChild("database")) != null) {
            this.databaseSetUp = new DatabaseSetUp(databaseElem, this.file.getParent());
        }
    }

    protected void loadExpect(Element expected) {
        Element databaseElem;
        Element component;
        Element catchElem;
        Element retElem = expected.getChild("return");
        if (retElem != null) {
            this.ret = new Return(retElem);
        }
        if ((catchElem = expected.getChild("catch")) != null) {
            this.catch_ = new Catch(catchElem);
        }
        if ((component = expected.getChild("component")) != null) {
            this.expectedObjects = new InjectedObjects(component, this.type);
        }
        if ((databaseElem = expected.getChild("database")) != null) {
            this.databaseAssertion = new DatabaseAssertion(databaseElem, this.file.getParent());
        }
    }

    public String getTarget() {
        return this.target;
    }

    public int getType() {
        return this.type;
    }

    public Execute getExecute() {
        return this.execute;
    }

    public InjectedObjects getInjectedObjects() {
        return this.injectedObjects;
    }

    public DatabaseSetUp getDatabaseSetUp() {
        return this.databaseSetUp;
    }

    public Return getReturn() {
        return this.ret;
    }

    public Catch getCatch() {
        return this.catch_;
    }

    public InjectedObjects getExpectedObjects() {
        return this.expectedObjects;
    }

    public DatabaseAssertion getDatabaseAssertion() {
        return this.databaseAssertion;
    }
}

