/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.dicon;

import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.inspector.Inspector;
import bodybuilder.test.TestCaseXML;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.test.dicon.DIConTestCaseXML;
import bodybuilder.test.dicon.InjectedObjects;
import bodybuilder.util.Config;
import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;

public class DIConTestCase
extends XMLTestCase {
    protected DIConTestCaseXML xml = null;

    protected void setXML(TestCaseXML xml) {
        this.xml = (DIConTestCaseXML)xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() {
        DatabaseAssertion databaseAssertion;
        InjectedObjects expectedObjects;
        this.info("'" + this.getName() + "' is started .");
        this.debug("description is:" + Config.NL + this.xml.getDescription());
        String target = this.xml.getTarget();
        int type = this.xml.getType();
        this.debug("target is '" + target + "'(Type" + type + ").");
        InjectedObjects injectedObjects = this.xml.getInjectedObjects();
        Object component = this.buildComponent(target, type, injectedObjects);
        DatabaseSetUp databaseSetUp = this.xml.getDatabaseSetUp();
        if (databaseSetUp != null) {
            this.debug("set up database by '" + databaseSetUp.getFile() + "'.");
            databaseSetUp.setUp();
        }
        Execute execute = this.xml.getExecute();
        String method = execute.getMethod();
        Argument argument = execute.getArgument();
        this.debug("invoked method is '" + method + "' as '" + target + "'.");
        Object actualReturn = null;
        Throwable cause = null;
        try {
            Object var13_11;
            block18: {
                try {
                    actualReturn = ObjectUtils.invokeMethod(component, method, argument.getClasses(), argument.getArguments());
                    if (injectedObjects == null) break block18;
                    this.processComponent(injectedObjects, injectedObjects.getSuccesses(), "success");
                }
                catch (BodyBuilderException e) {
                    if (injectedObjects != null) {
                        this.processComponent(injectedObjects, injectedObjects.getFailures(), "failure");
                    }
                    if (!(e.getCause() instanceof InvocationTargetException)) {
                        throw e;
                    }
                    cause = e.getCause().getCause();
                    this.debug("'" + cause + "' was catched.");
                    var13_11 = null;
                    if (injectedObjects != null) {
                        this.processComponent(injectedObjects, injectedObjects.getWindUps(), "wind up");
                    }
                }
            }
            var13_11 = null;
            if (injectedObjects != null) {
                this.processComponent(injectedObjects, injectedObjects.getWindUps(), "wind up");
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (injectedObjects != null) {
                this.processComponent(injectedObjects, injectedObjects.getWindUps(), "wind up");
            }
            throw throwable;
        }
        this.debug("'" + method + "' was invoked.");
        Catch expectedCatch = this.xml.getCatch();
        if (expectedCatch != null && ObjectUtils.instance_of((Object)cause, expectedCatch.getType())) {
            this.debug("verify catched exception.");
            Inspector.assertObjectEquals(expectedCatch.getException(), cause);
            this.debug("catched exception value was corrected.");
        } else {
            if (expectedCatch != null) {
                throw new BodyBuilderException("unexpected exception '" + cause + "' but was '" + expectedCatch.getType() + "'.", cause);
            }
            if (cause != null) {
                throw new BodyBuilderException("unexpected exception '" + cause + "'.", cause);
            }
        }
        Return expectedReturn = this.xml.getReturn();
        if (expectedReturn != null) {
            this.debug("verify return value.");
            Inspector.assertObjectEquals(expectedReturn.getValue(), actualReturn);
            this.debug("return value was corrected.");
        }
        if ((expectedObjects = this.xml.getExpectedObjects()) != null) {
            String[] names = expectedObjects.getNames();
            for (int i = 0; i < names.length; ++i) {
                this.debug("verify object '" + names[i] + "' as '" + component + "'.");
                Object expectedObject = expectedObjects.getObject(names[i]);
                Object actualObject = injectedObjects.getObject(names[i]);
                Inspector.assertObjectEquals(expectedObject, actualObject);
                this.debug("'" + names[i] + "' was corrected.");
            }
        }
        if ((databaseAssertion = this.xml.getDatabaseAssertion()) != null) {
            this.debug("verify database by '" + databaseAssertion.getFile() + "'.");
            databaseAssertion.assertDataSetEquals();
            this.debug("database was corrected.");
        }
        this.info("test was ended.");
    }

    private Object buildComponent(String target, int type, InjectedObjects injectedObjects) {
        Object component = null;
        switch (type) {
            case 2: {
                this.debug("build component.");
                component = ObjectUtils.getObject(target);
                if (injectedObjects == null) break;
                Map objects = injectedObjects.getObjectMap();
                Iterator names = objects.keySet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    Object object = objects.get(name);
                    this.debug("inject object '" + name + "'.");
                    ExtendedPropertyUtils.setProperty(component, name, object);
                }
                break;
            }
            case 3: {
                if (injectedObjects == null) {
                    throw new BodyBuilderException("undefined injection objects for type 3.");
                }
                Class[] classes = injectedObjects.getClasses();
                Object[] arguments = injectedObjects.getObjects();
                this.debug("build component and inject objects.");
                component = ObjectUtils.getInstance(target, classes, arguments);
                break;
            }
            default: {
                throw new BodyBuilderException("uninplemented injection type '" + type + "'.");
            }
        }
        return component;
    }

    private void processComponent(InjectedObjects injectedObjects, Map methods, String processName) {
        String[] names = injectedObjects.getNames();
        for (int i = 0; i < names.length; ++i) {
            Object component = injectedObjects.getObject(names[i]);
            Execute[] executes = (Execute[])methods.get(names[i]);
            if (executes == null || executes.length < 1) continue;
            this.debug(processName + " process of component '" + names[i] + "'.");
            for (int j = 0; j < executes.length; ++j) {
                String method = executes[j].getMethod();
                Argument argument = executes[j].getArgument();
                this.debug("execute method '" + method + "' as '" + component.getClass().getName() + "' as " + processName + ".");
                ObjectUtils.invokeMethod(component, executes[j].getMethod(), argument.getClasses(), argument.getArguments());
            }
        }
    }
}

