package sample.util;

import java.io.IOException;
import java.io.InputStream;

public class SampleUtils {

    public static InputStream getResourceAsStream(String name) {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();

        if (cloader == null)
            cloader = SampleUtils.class.getClassLoader();

        InputStream istream = cloader.getResourceAsStream(name);

        if (istream == null)
            throw new RuntimeException("Could not find resource \"" + name
                    + "\".");

        return istream;
    }

    public static void closeInputStream(InputStream istream) {
        try {
            istream.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

}