package sample.viewer.extension;

import sample.object.UserDefined;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * ユーザ定義クラスビューア
 */
public class UserDefinedViewer extends Viewer {

    /**
     * ユーザ定義クラスの内容を出力する。
     * 
     * @param object ユーザ定義クラス
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // ユーザ定義クラスにキャスト。
        UserDefined userDifined = (UserDefined) object;
        // クラスの情報と開きカッコを出力。
        handler.print(ObjectUtils.getInfo(object) + " {");
        // 出力をインデント。
        handler.indent();

        // メッセージを出力。
        handler.print("[message]=>\"" + userDifined.message() + "\"");

        // 出力をアンインデント。
        handler.unindent();
        // 閉じカッコを出力。
        handler.print("}");
    }

}