package bodybuilder.builder;

import java.lang.reflect.Array;
import java.util.List;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.util.ObjectUtils;

/**
 * 配列ビルダー
 */
public class ArrayBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
    }

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "elem";

    /**
     * 配列を取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return 配列
     */
    public Object getMuscle(Element element, Argument constructor) {
        // <elem>を取得。
        List children = element.getChildren(METHOD_NAME);

        // 配列の型を取得。
        String type = getType(element);
        Class clazz = (type != null) ? ObjectUtils.getClass(type)
                : Object.class;

        // 配列を生成。
        Object array = Array.newInstance(clazz, children.size());

        // <elem>の値を配列に格納。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            Object value = getValue(child, type);
            Array.set(array, i, value);
        }

        // 配列を返す。
        return array;
    }

}