package bodybuilder.builder.bean;

import java.util.List;
import org.jdom.Element;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;
import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;

/**
 * ビーンビルダー
 */
public class BeanBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "prop";

    /**
     * ビーンを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return ビーン
     */
    public Object getMuscle(Element element, Argument constructor) {
        // ビーンのクラスを取得。
        String type = getRequiredType(element);
        Class clazz = ObjectUtils.getClass(type);

        // ビーンを生成。
        Object bean = null;

        if (clazz.isInterface()) {
            // インターフェースの場合は動的にインスタンスを生成。
            DynaBean dbean = new DynaBean(clazz);
            bean = dbean.newInstance();
        } else {
            bean = newObject(type, constructor);
        }

        // <prop>を取得。
        List children = element.getChildren(METHOD_NAME);

        // <prop>の値をビーンに格納。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            ExtendedPropertyUtils.setProperty(bean, name, value);
        }

        // ビーンを返す。
        return bean;
    }

}