package bodybuilder.test;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import bodybuilder.util.Config;
import junit.framework.TestCase;

/**
 * 抽象XMLテストケース
 */
public abstract class XMLTestCase extends TestCase {

    private Log logger = LogFactory.getLog(this.getClass());

    /**
     * テストケースマップ
     */
    private static Map testCaseMap = Config.getTestCaseMap();

    /**
     * テストケースXMLをセットする。
     * 
     * @param xml テストケースXML
     */
    protected abstract void setXML(TestCaseXML xml);

    /////////////////////////////////////////////////////////////////
    // logging method

    /**
     * デバッグログを出力する。
     * 
     * @param message メッセージ
     */
    protected void debug(String message) {
        logger.debug("[" + getName() + "] " + message);
    }

    /**
     * 情報ログを出力する。
     * 
     * @param message メッセージ
     */
    protected void info(String message) {
        logger.info("[" + getName() + "] " + message);
    }

    /**
     * 警告ログを出力する。
     * 
     * @param message メッセージ
     */
    protected void warn(String message) {
        logger.warn("[" + getName() + "] " + message);
    }

}