package bodybuilder.test.jsp;

import bodybuilder.util.Utils;

/**
 * 設定
 */
public class Config extends bodybuilder.util.Config {

    /**
     * JSPテストケースのプロパティのプリフィックス
     */
    protected static final String JSP_TESTCASE_PROP_PREFIX = TEST_PROP_KEY_PREFIX
            + "jsptestcase.";

    /**
     * コンテキストルートを取得する。
     * 
     * @return コンテキストルート
     */
    public static String getContextRoot() {
        String contextRoot = getRequiredProperty(JSP_TESTCASE_PROP_PREFIX
                + "context.root");

        return Utils.formatSlash(contextRoot, false, false);
    }

    /**
     * リダイレクタのパスを取得する。
     * 
     * @return リダイレクタのパス
     */
    public static String getRedirectorPath() {
        String path = getRequiredProperty(JSP_TESTCASE_PROP_PREFIX
                + "redirector.path");

        return Utils.formatSlash(path);
    }

    /**
     * リクエストの文字セットを取得する。
     * 
     * @return リクエストの文字セット
     */
    public static String getRequestCharset() {
        String charset = getProperty(JSP_TESTCASE_PROP_PREFIX
                + "request.charset");

        // 取得できない場合はShift_JIS。
        if (charset == null) {
            charset = "Shift_JIS";
        }

        return charset;
    }

    /**
     * 初期化リクエストのパスを取得する。
     * 
     * @return リクエストの文字セット
     */
    public static String getInitRequestPath() {
        String path = getProperty(JSP_TESTCASE_PROP_PREFIX
                + "init.request.path");

        // 取得できない場合はnull。
        if (path != null && "".equals(path.trim())) {
            path = null;
        }

        return path;
    }

}