/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector.servlet;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.ServletObjectUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RequestInspector
extends Inspector {
    public void assertEquals(Object expected, Object actual, ObjectBackTrace trace) {
        HttpServletRequest expectedRequest = (HttpServletRequest)expected;
        HttpServletRequest actualRequest = (HttpServletRequest)actual;
        Map expectedParams = ServletObjectUtils.getRequestParameters(expectedRequest);
        Map actualParams = ServletObjectUtils.getRequestParameters(actualRequest);
        this.assertRequestValue("parameter", expectedParams, actualParams, trace);
        Map expectedAttrs = ServletObjectUtils.getRequestAttributes(expectedRequest);
        Map actualAttrs = ServletObjectUtils.getRequestAttributes(actualRequest);
        this.assertRequestValue("attribute", expectedAttrs, actualAttrs, trace);
    }

    private void assertRequestValue(String type, Map expected, Map actual, ObjectBackTrace trace) {
        Set expectedNameSet = expected.keySet();
        RequestInspector.assertKeySetEquals(type + " name set differ", expectedNameSet, actual.keySet(), trace);
        Iterator names = expectedNameSet.iterator();
        while (names.hasNext()) {
            Object name = names.next();
            trace.appendKey(name, "(" + type + ")");
            Object expectedElement = expected.get(name);
            Object actualElement = actual.get(name);
            RequestInspector.assertObjectEquals(expectedElement, actualElement, trace);
        }
    }
}

