package sample.testtarget.usually;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 日付ユーティリティ
 */
public class DateUtils {

    private Date date = null;

    /**
     * コンストラクタ。
     * 
     * @param source 日付文字列
     */
    public DateUtils(String source) {
        // 日付文字列の書式をチェック。
        if (source == null || !source.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}$")) {
            throw new RuntimeException();
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

        // 日付文字列をパースして、フィールドにセット。
        try {
            date = format.parse(source);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * コンストラクタ。
     * 
     * @param date 日付オブジェクト
     */
    public DateUtils(Date date) {
        this.date = date;
    }

    /**
     * 日付/時刻を加算する。
     * 
     * @param field 時間フィールド
     * @param amount  フィールドに追加する日付または時刻の量
     * @return 日付オブジェクト
     */
    public Date add(int field, int amount) {
        // カレンダーを取得。
        Calendar cal = Calendar.getInstance();

        // 日付/時刻を加算。
        cal.setTime(date);
        cal.add(field, amount);

        // 加算した値を返す。
        return cal.getTime();
    }

}