package bodybuilder.ant.xmltest;

import java.util.List;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;

/**
 * 拡張コマンドライン
 */
public class ExtendedCommandlineJava extends CommandlineJava {

    /////////////////////////////////////////////////////////////////
    // path constant field

    /**
     * パス置換用のシステムプロパティキー
     */
    private static final String PATH_REPLACE_KEY = "@"
            + ExtendedCommandlineJava.class.getName() + "@PATH_REPLACE_KEY";

    /**
     * パス置換用のシステムプロパティ値
     */
    private static final String PATH_REPLACE_VALUE = "@"
            + ExtendedCommandlineJava.class.getName() + "@PATH_REPLACE_VALUE";

    /**
     * パス置換用のシステムプロパティ
     */
    private static final String PATH_REPLACE_SYSPROP = "-D" + PATH_REPLACE_KEY
            + "=" + PATH_REPLACE_VALUE;

    /**
     * パスのシステムプロパティのプリフィックス
     */
    private static final String PATH_PROPERTY_PREFIX = "-D"
            + XMLJUnitTask.TEST_PROP_KEY_ROOT_DIRS + "=";

    /////////////////////////////////////////////////////////////////
    // path constant field

    /**
     * 深さ置換用のシステムプロパティキー
     */
    private static final String DEPTH_REPLACE_KEY = "@"
            + ExtendedCommandlineJava.class.getName() + "@DEPTH_REPLACE_KEY";

    /**
     * 深さ置換用のシステムプロパティ値
     */
    private static final String DEPTH_REPLACE_VALUE = "@"
            + ExtendedCommandlineJava.class.getName() + "@DEPTH_REPLACE_VALUE";

    /**
     * 深さ置換用のシステムプロパティ
     */
    private static final String DEPTH_REPLACE_SYSPROP = "-D"
            + DEPTH_REPLACE_KEY + "=" + DEPTH_REPLACE_VALUE;

    /**
     * 深さのシステムプロパティのプリフィックス
     */
    private static final String DEPTH_PROPERTY_PREFIX = "-D"
            + XMLJUnitTask.TEST_PROP_KEY_DEPTH + "=";

    /////////////////////////////////////////////////////////////////
    // constructor

    /**
     * コンストラクタ。
     */
    public ExtendedCommandlineJava() {
        super();
        // 置換用のシステムプロパティを追加。
        addSysproperty(PATH_REPLACE_KEY, PATH_REPLACE_VALUE);
        addSysproperty(DEPTH_REPLACE_KEY, DEPTH_REPLACE_VALUE);
    }

    /**
     * システムプロパティを追加する。
     * 
     * @param key キー
     * @param value 値
     */
    private void addSysproperty(String key, String value) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(key);
        var.setValue(value);
        super.addSysproperty(var);
    }

    /////////////////////////////////////////////////////////////////
    // path list

    /**
     * パスリスト
     */
    private List pathList = null;

    /**
     * パスリストをセットする。
     * 
     * @param pathList パスリスト
     */
    public void setPathList(List pathList) {
        this.pathList = pathList;
    }

    /////////////////////////////////////////////////////////////////
    // depth

    /**
     * ディレクトリの深さ
     */
    private int depth = 4;

    /**
     * ディレクトリの深さをセットする。
     * 
     * @param depth ディレクトリの深さ
     */
    public void setDepth(int depth) {
        this.depth = depth;
    }

    /////////////////////////////////////////////////////////////////
    // commandline

    /**
     * コマンドラインを取得する。
     * 
     * return コマンドライン
     */
    public String[] getCommandline() {
        // コマンドラインを取得。
        String[] commandline = super.getCommandline();

        // パスリストが空の場合はコマンドラインをそのまま返す。
        if (pathList == null || pathList.size() < 1) {
            return commandline;
        }

        // コマンドラインのシステムプロパティを置換。
        for (int i = 0; i < commandline.length; i++) {
            if (PATH_REPLACE_SYSPROP.equals(commandline[i])) {
                commandline[i] = PATH_PROPERTY_PREFIX + pathList.remove(0);
            } else if (DEPTH_REPLACE_SYSPROP.equals(commandline[i])) {
                commandline[i] = DEPTH_PROPERTY_PREFIX + depth;
            }
        }

        // システムプロパティを返す。
        return commandline;
    }

    /**
     * コマンドラインを記述する。
     */
    public String describeCommand() {
        return Commandline.describeCommand(super.getCommandline());
    }

}