package bodybuilder.builder.servlet;

import java.util.List;

import javax.servlet.http.HttpSession;

import org.jdom.Element;

import com.mockrunner.mock.web.MockHttpSession;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;

/**
 * セッションビルダー
 */
public class SessionBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
    }

    /**
     * メソッド名
     */
    private static final String METHOD_ATTR = "attr";

    /**
     * セッションを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return セッション
     */
    public Object getMuscle(Element element, Argument constructor) {
        // モックセッションを生成。
        MockHttpSession session = new MockHttpSession();
        // セッションをセットアップ。
        setup(element, session);
        // セッションを返す。
        return session;
    }

    /**
     * セッションをセットアップする。
     * 
     * @param element XML要素
     * @param session セッション
     */
    public static void setup(Element element, HttpSession session) {
        // <attr>を取得。
        List attrs = element.getChildren(METHOD_ATTR);

        // 属性をセッションにセット。
        for (int i = 0; i < attrs.size(); i++) {
            Element child = (Element) attrs.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            session.setAttribute(name, value);
        }
    }

}