package bodybuilder.inspector.servlet;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.ServletObjectUtils;

/**
 * リクエストインスペクター
 */
public class RequestInspector extends Inspector {

    /**
     * 二つのリクエストが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // リクエストを取得。
        HttpServletRequest expectedRequest = (HttpServletRequest) expected;
        HttpServletRequest actualRequest = (HttpServletRequest) actual;

        // パラメータを取得。
        Map expectedParams = ServletObjectUtils
                .getRequestParameters(expectedRequest);
        Map actualParams = ServletObjectUtils
                .getRequestParameters(actualRequest);
        // パラメータを検査。
        assertRequestValue("parameter", expectedParams, actualParams, trace);

        // 属性を取得。
        Map expectedAttrs = ServletObjectUtils
                .getRequestAttributes(expectedRequest);
        Map actualAttrs = ServletObjectUtils
                .getRequestAttributes(actualRequest);
        // 属性を検査。
        assertRequestValue("attribute", expectedAttrs, actualAttrs, trace);
    }

    /**
     * 二つのリクエストの値が等しいことを表明する。
     * 
     * @param type 値のタイプ
     * @param expected 期待する値
     * @param actual 実際の値
     * @param trace バックトレース
     */
    private void assertRequestValue(String type, Map expected, Map actual,
            ObjectBackTrace trace) {
        // 項目名を検査。
        Set expectedNameSet = expected.keySet();
        assertKeySetEquals(type + " name set differ", expectedNameSet, actual
                .keySet(), trace);
        Iterator names = expectedNameSet.iterator();

        // 値を検査。
        while (names.hasNext()) {
            Object name = names.next();
            trace.appendKey(name, "(" + type + ")");
            Object expectedElement = expected.get(name);
            Object actualElement = actual.get(name);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}