package bodybuilder.test.database;

import java.io.File;
import java.util.Map;

import org.jdom.Element;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.FileUtils;
import bodybuilder.util.dbunit.DbUnitUtils;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * データベースセットアップ
 */
public class DatabaseSetUp {

    static {
        try {
            // JDBCドライバを登録。
            DbUnitUtils.registerDriver(Config.getDatabaseDriver());
        } catch (Throwable e) {
            e.printStackTrace();
            throw new BodyBuilderException("failed to initialize '"
                    + DatabaseSetUp.class.getName() + "'.", e);
        }
    }

    /**
     * ファイル名
     */
    private String file = null;

    /**
     * データセットのタイプ
     */
    private String type = null;

    /**
     * コンストラクタ。
     * 
     * @param element XML要素
     * @param baseDir ベースディレクトリ
     */
    public DatabaseSetUp(Element element, String baseDir) {
        // ファイル名を取得。
        file = JDOMUtils.getRequiredAttrValue(element, "file");

        // ファイル名がフルパスではない場合、ファイル名にベースディレクトリをくっつける。
        if (!FileUtils.isFullPath(file)) {
            file = baseDir + File.separator + file;
        }

        // データセットのタイプを取得。
        type = element.getAttributeValue("type");

        // データセットのタイプを取得できない場合は拡張子から判定。
        if (type == null) {
            Map dataSetMap = Config.getDataSetMap();
            type = (String) dataSetMap.get(FileUtils.getExt(file));
        }
    }

    /**
     * データベースをセットアップする。
     */
    public void setUp() {
        // データベースのプロパティを取得。
        String driver = Config.getDatabaseDriver();
        String url = Config.getDatabaseUrl();
        String user = Config.getDatabaseUser();
        String password = Config.getDatabasePassword();

        // データベースをセットアップ。
        DbUnitUtils utils = new DbUnitUtils(url, user, password);
        utils.setUpDatabase(file, type);
    }

    /**
     * ファイル名を取得する。
     * 
     * @return ファイル名
     */
    public String getFile() {
        return file;
    }

    /**
     * データセットのタイプを取得する。
     * 
     * @return データセットのタイプ。
     */
    public String getType() {
        return type;
    }

}